DROP TABLE nc_userStatus CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_userStatus 
--

CREATE TABLE nc_userStatus(
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    userStatus     VARCHAR2(16),
    name           VARCHAR2(128),
    description    CLOB,
    CONSTRAINT nc_userStatus_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_userStatus_pidx on nc_userStatus(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_userStatus_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_userStatus_sidx on nc_userStatus(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_userStatus.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_userStatus.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_userStatus.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_userStatus.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_userStatus.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_userStatus.userStatus IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_userStatus.name IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_userStatus.description IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
