drop table nc_protocolmanip ;

create table nc_protocolmanip(
    uniqueid                       bigint    not null,
    tableid                        bigint    not null,
    owner                          bigint    not null,
    modtime timestamp not null,
    moduser                        bigint    not null,
    type                           varchar(18),
    start_value                    bigint     default 1 not null,
    end_value                      bigint     default 1 not null,
    protocolversion                bigint     default 1 not null,
    protocolid                     varchar(64)     not null,
    nc_expmanipulation_uniqueid    bigint    not null,
    constraint nc_protocolmanip_pk primary key (uniqueid) ,
    constraint nc_protocolmanip_sk  unique (uniqueid, tableid) );

-- comment on column nc_protocolmanip.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_protocolmanip.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_protocolmanip.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_protocolmanip.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_protocolmanip.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_protocolmanip.start_value is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_protocolmanip.end_value is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_protocolmanip.protocolversion is 'the versionid domain is used to denote version identifiers. these identifiers can have major and minor revisions.' ;

-- comment on column nc_protocolmanip.protocolid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_protocolmanip.nc_expmanipulation_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

