drop table nc_tuplecolumns ;

create table nc_tuplecolumns(
    extendedtupleid      bigint    not null,
    columnname           varchar(128)    not null,
    columntype           varchar(64)     not null,
    tableid              bigint    not null,
    uniqueid             bigint    not null,
    owner                bigint    not null,
    modtime timestamp not null,
    moduser              bigint    not null,
    defaultvalue         varchar(255),
    nullable             boolean     not null,
    columnontology       varchar(128)    not null,
    columnconcept        varchar(64)     not null,
    measurementsystem    varchar(128),
    measurementunit      varchar(64),
    constraint nc_tuplecolumns_pk primary key (extendedtupleid, columnname, columntype) ,
    constraint nc_tuplecolumns_uk_extcol  unique (extendedtupleid, columnname) ,
    constraint nc_tuplecolumns_sk  unique (uniqueid, tableid) );

-- comment on column nc_tuplecolumns.extendedtupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tuplecolumns.columnname is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_tuplecolumns.columntype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_tuplecolumns.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_tuplecolumns.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tuplecolumns.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_tuplecolumns.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_tuplecolumns.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_tuplecolumns.defaultvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_tuplecolumns.nullable is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_tuplecolumns.columnontology is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_tuplecolumns.columnconcept is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_tuplecolumns.measurementsystem is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_tuplecolumns.measurementunit is 'the name column is used to store the name of the object being described by the tuple. ' ;

