drop table nc_tuplefloat ;

create table nc_tuplefloat(
    tableid            bigint       not null,
    uniqueid           bigint       not null,
    owner              bigint       not null,
    modtime timestamp not null,
    moduser            bigint       not null,
    extendedtupleid    bigint       not null,
    columnname         varchar(128)       not null,
    columntype         varchar(64)        not null,
    basetableid        bigint       not null,
    basetupleid        bigint       not null,
    textvalue          varchar(255),
    comments           text,
    datavalue          double precision,
    constraint nc_tuplefloat_pk primary key (tableid, uniqueid) ,
    constraint nc_tuplefloat_sk  unique (uniqueid, tableid) );

-- comment on column nc_tuplefloat.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_tuplefloat.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tuplefloat.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_tuplefloat.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_tuplefloat.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_tuplefloat.extendedtupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tuplefloat.columnname is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_tuplefloat.columntype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_tuplefloat.basetableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_tuplefloat.basetupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tuplefloat.textvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_tuplefloat.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

