CREATE FUNCTION nc_expevent_ins_upd() RETURNS trigger AS '
BEGIN
     new.uniqueid := new.expmanipulationid; 
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expevent_ins_upd  before insert or update on nc_expevent  for each row   EXECUTE PROCEDURE nc_expevent_ins_upd();

CREATE FUNCTION nc_expevent_insert() RETURNS trigger AS '
BEGIN
  insert into nc_expmanipulation
    (uniqueid, tableid, owner,
     modtime, moduser,extensionname, ontologysource,
     conceptid)
   values(
    new.expmanipulationid,
    new.tableid,
    new.owner,
    new.modtime,
    new.moduser,
    new.extensionname,
    new.ontologysource,
    new.conceptid
   );
   return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expevent_insert  after insert on nc_expevent  for each row  EXECUTE PROCEDURE nc_expevent_insert();

CREATE FUNCTION nc_expevent_update() RETURNS trigger AS '
BEGIN
  update nc_expmanipulation
     set 
       tableid = new.tableid,
       owner = new.owner,
       modtime = new.modtime,
       moduser = new.moduser,
       extensionname = new.extensionname,
       ontologysource = new.ontologysource,
       conceptid = new.conceptid
   where 
     uniqueid = new.expmanipulationid;
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expevent_update  after update on nc_expevent  for each row  EXECUTE PROCEDURE nc_expevent_update();

CREATE FUNCTION nc_expevent_delete() RETURNS trigger AS '
BEGIN
 delete from nc_expmanipulation
 where 
   uniqueid = old.expmanipulationid;
 return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expevent_delete  after delete on nc_expevent  for each row  EXECUTE PROCEDURE nc_expevent_delete();

