DROP TABLE nc_assessmentTimeStamp CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentTimeStamp 
--

CREATE TABLE nc_assessmentTimeStamp(
    tableID                       NUMBER(38, 0)    NOT NULL,
    nc_assessmentData_uniqueID    NUMBER(38, 0)    NOT NULL,
    scoreOrder                    NUMBER(38, 0)    NOT NULL,
    owner                         NUMBER(38, 0)    NOT NULL,
    modTime                       DATE             NOT NULL,
    modUser                       NUMBER(38, 0)    NOT NULL,
    textValue                     VARCHAR2(255),
    textNormValue                 VARCHAR2(255),
    comments                      CLOB,
    dataValue                     TIMESTAMP(6),
    dataNormValue                 TIMESTAMP(6),
    storedAssessmentID            NUMBER(38, 0)    NOT NULL,
    assessmentID                  NUMBER(38, 0)    NOT NULL,
    scoreName                     VARCHAR2(128)    NOT NULL,
    scoreType                     VARCHAR2(64)     NOT NULL,
    isValidated                   NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    isRanked                      NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    subjectID                     VARCHAR2(64)     NOT NULL,
    entryID                       NUMBER(38, 0),
    keyerID                       NUMBER(38, 0),
    raterID                       NUMBER(38, 0),
    classification                NUMBER(38, 0),
    uniqueID                      NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_assessmentTimeStamp_pk PRIMARY KEY (tableID, nc_assessmentData_uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentTimeStamp_pidx on nc_assessmentTimeStamp(tableID, nc_assessmentData_uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentTimeStamp_sk  UNIQUE (nc_assessmentData_uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentTimeStamp_sidx on nc_assessmentTimeStamp(nc_assessmentData_uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_assessmentTimeStamp.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.nc_assessmentData_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.scoreOrder IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.textNormValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.dataValue IS 'The timestampData domain is used to hold native timestamps.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.dataNormValue IS 'The timestampData domain is used to hold native timestamps.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.storedAssessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentTimeStamp.scoreType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.isValidated IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.isRanked IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.entryID IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.keyerID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.raterID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.classification IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentTimeStamp.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
