DROP TABLE nc_experiment CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_experiment 
--

CREATE TABLE nc_experiment(
    uniqueID            NUMBER(38, 0)     NOT NULL,
    tableID             NUMBER(38, 0)     NOT NULL,
    owner               NUMBER(38, 0)     NOT NULL,
    modTime             DATE              NOT NULL,
    modUser             NUMBER(38, 0)     NOT NULL,
    name                VARCHAR2(128)     NOT NULL,
    description         CLOB,
    contactPerson       NUMBER(38, 0)     NOT NULL,
    baseURI             VARCHAR2(2048),
    isRegressionData    NUMBER(1, 0)       DEFAULT 0,
    CONSTRAINT nc_experiment_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_experiment_pidx on nc_experiment(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_experiment_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_experiment_sidx on nc_experiment(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_experiment.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_experiment.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_experiment.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_experiment.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_experiment.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_experiment.name IS 'Textual name of the experiment.'
;
COMMENT ON COLUMN nc_experiment.description IS 'Dewscription of the experiment.'
;
COMMENT ON COLUMN nc_experiment.contactPerson IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_experiment.baseURI IS 'The root URI for the data from this experiment'
;
COMMENT ON COLUMN nc_experiment.isRegressionData IS 'If flag is set to true, data is not real experimental data, rather it is a regression (or testing) data set'
;
