DROP TABLE nc_tableID CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_tableID 
--

CREATE TABLE nc_tableID(
    tableName       VARCHAR2(200)    NOT NULL,
    uniqueID        NUMBER(38, 0)    NOT NULL,
    tableID         NUMBER(38, 0)    NOT NULL,
    owner           NUMBER(38, 0)    NOT NULL,
    modTime         DATE             NOT NULL,
    modUser         NUMBER(38, 0)    NOT NULL,
    majorVersion    NUMBER(38, 0)    NOT NULL,
    minorVersion    NUMBER(38, 0)    NOT NULL,
    description     CLOB,
    CONSTRAINT nc_tableID_pk PRIMARY KEY (tableName)
 		USING INDEX
 		(CREATE INDEX nc_tableID_pidx on nc_tableID(tableName)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tableID_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_tableID_sidx on nc_tableID(uniqueID, tableID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tableID_uk_tableID  UNIQUE (tableID)
 		USING INDEX
 		(CREATE INDEX nc_tableID_uidx on nc_tableID(tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_tableID.tableName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tableID.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tableID.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_tableID.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tableID.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_tableID.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tableID.majorVersion IS 'The versionID domain is used to denote version identifiers. These identifiers can have major and minor revisions.'
;
COMMENT ON COLUMN nc_tableID.minorVersion IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_tableID.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
