--

create or replace PROCEDURE drop_object(object_type_in VARCHAR2, object_name_in VARCHAR2) 
IS
   cursor_id INTEGER;
BEGIN
  cursor_id := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(cursor_id, 'DROP ' || object_type_in ||
        ' ' || object_name_in, DBMS_SQL.NATIVE);
  DBMS_SQL.CLOSE_CURSOR(cursor_id);
  EXCEPTION
    WHEN OTHERS
    THEN
       DBMS_SQL.CLOSE_CURSOR(cursor_id);
END;
/

DECLARE
 CURSOR triggers_cur IS SELECT  TRIGGER_NAME from user_triggers;
 tr_rec triggers_cur%ROWTYPE;
BEGIN
   FOR tr_rec IN triggers_cur
   LOOP
     drop_object('trigger', tr_rec.TRIGGER_NAME);
   END LOOP;   
END;
/
