#!/bin/sh

# TODO:
#      Write the two called functions
#      Test

read_key_from_patch()
{
  file=$1
  key=$2

  line=`grep " -- $key: " $file`
  ret=${line/ -- $key: /}
}

GetCurrentHIDVersion()
{
  # Fetch their current version from the database
  current_version_info=`echo -e "SELECT majorversion, minorversion FROM nc_schemaversion WHERE modtime=(SELECT max(modtime) FROM nc_schemaversion WHERE updateFinished=1) and updateFinished=1;\nexit;" | sqlplus $connection_string`
  OIFS=$IFS
  IFS='
'	# Set the field separator to not split fields on spaces or tabs - only newlines.
  counter=0
  current_minorversion="NONE"
  current_majorversion="NONE"
  for line in $current_version_info
  do 
    if [ x"$line" = x"MAJORVERSION MINORVERSION" ]	# Two lines after we encounter this, we want to grab the line to get the current version out.
    then
      counter=2
    else
      if [ $counter -gt 0 ]
      then
        counter=`expr $counter - 1`
        if [ $counter -eq 0 ]
        then
	  IFS=$OIFS
	  for i in $line
	  do
	    if [ x"$current_majorversion" = x"NONE" ]
	    then
              current_majorversion=$i
	    else
	      current_minorversion=$i
	    fi
	  done
	  break
        fi
      fi
    fi
  done
  IFS=$OIFS

  # If the current version was never set, then we're missing a row in the database.
  if [ x"$current_minorversion" = x"NONE" ]
  then
    echo "ERROR: Your database does not have versioning information in it.  Please correct this."
    exit 2
  fi

  ret1=$current_minorversion
  ret2=$current_majorversion
}

# Check to make sure that they've provided the patch name.
if [ "$#" -ne 2 ]
then
  echo "Usage: create_update.sh <sqlplus connection string> <filename>"
  exit 1
fi

connection_string=$1
patchname=$2
# Make sure that the patch exists
if [ `stat "$patchname" 2>/dev/null | grep -c "File:"` -eq 0 ]
then
  echo "ERROR: Update patch not found."
  exit 1
fi

# Do a CVS update to make sure that this update goes at the end of the list.
echo "Calling CVS update to ensure that the update goes at the end:"
cvs update 2>&1 | tee create_update_logfile
count=`grep -c "cvs update: Updating" create_update_logfile`
if [ x"$count" = "x" ]
then
  echo "ERROR: CVS update failed.  Exiting."
  exit 2
fi
rm create_update_logfile

# Get the last version from the available patches.
last_majornumber=1
last_minornumber=0
for file in `ls *.*_*.sql 2> /dev/null`
do
  temp_majornumber=`echo "$file" | cut -d"." -f1`
  temp_minornumber=`echo "$file" | cut -d"." -f2 | cut -d"_" -f1`
  if [ $temp_majornumber -gt $last_majornumber ]
  then
    last_majornumber=$temp_majornumber
    last_minornumber=$temp_minornumber
  else
    if [ $temp_majornumber -eq $last_majornumber -a $temp_minornumber -gt $last_minornumber ]
    then
      last_majornumber=$temp_majornumber
      last_minornumber=$temp_minornumber
    fi
  fi
done

# Verify that they've been testing with the most recent DB version.
GetCurrentHIDVersion; current_minorversion=$ret1; current_majorversion=$ret2
if [ x$current_minorversion != x$last_minornumber -o x$current_majorversion != x$last_majornumber ]; then
  echo "ERROR: You are not using the most recent version of the database for testing.  Please update, then retest your patch."
  exit 1
fi

# Now, prompt the user for all of the metadata that we're going to need
# First, do they want this to have a new major number?
echo -n "Is this to be a new major release? [y[n]] "
read yn
if [ x"$yn" = x"y" ]
then
  majornumber=`expr $last_majornumber + 1`
  minornumber=0
else
  majornumber=$last_majornumber
  minornumber=`expr $last_minornumber + 1`
fi

# Get an update name.
echo -n "Enter a name for this update: "
read update_name

# Validate the update
update_version=0
update_filename=`ls *.*_"$update_name".sql 2>/dev/null`
if [ `stat "$update_filename" 2>/dev/null | grep -c "File:"` -gt 0 ]
then
  # Hmm, they're resubmitting a patch!  Lets confirm that this is what they want.
  echo -n "NOTICE: This patch already exists.  Upgrade it? [y[n]] "
  read yn
  if [ x"$yn" = x"y" ]
  then
    read_key_from_patch $update_filename "Version"; old_update_version=$ret
    update_version=`expr $old_update_version + 1`
    majornumber=`echo "$update_filename" | cut -d"." -f1`
    minornumber=`echo "$update_filename" | cut -d"." -f2 | cut -d"_" -f1`
    last_majornumber=$majornumber
    last_minornumber=`expr $minornumber - 1`
    if [ $last_minornumber -lt 0 ]
    then
      last_majornumber=`expr $majornumber - 1`
      # Figure out the largest minor number of the last update series.
      last_minornumber=0
      for file in `ls $last_majornumber.*_*.sql`
      do
        temp_minornumber=`echo "$file" | cut -d"." -f2 | cut -d"_" -f1`
        if [ $last_minornumber -lt $temp_minornumber ]
	then
          last_minornumber=$temp_minornumber
	fi
      done
    fi
    echo "Upgrading patch from $old_update_version to $update_version."
  else
    echo "Cancelled."
    exit 0
  fi
else
  update_filename="$majornumber"."$minornumber"_"$update_name.sql"
fi

echo "New update will be version $majornumber.$minornumber."

# Get the description
echo -n "Enter a description for this update: "
read update_description

# Get the release date
releasedate=`date +"%d-%b-%Y"`

# Add all of the information, along with the function calls, into the final update file.
echo " -- *** Begin Autogenerated Header ***" > create_update_tempfile
echo " --" >> create_update_tempfile
echo " -- Name: $update_name" >> create_update_tempfile
echo " -- Description: $update_description" >> create_update_tempfile
echo " -- Version: $update_version" >> create_update_tempfile
echo " --" >> create_update_tempfile
echo " -- *** Calling Version Checker ***" >> create_update_tempfile
echo "whenever SQLerror exit 1" >> create_update_tempfile
echo "DECLARE" >> create_update_tempfile
echo "  CRU_proper_version NUMBER;" >> create_update_tempfile
echo "  CRU_temp NUMBER;" >> create_update_tempfile
echo "BEGIN" >> create_update_tempfile
echo "  SELECT check_for_schema_version($last_majornumber, $last_minornumber) INTO CRU_proper_version FROM DUAL;" >> create_update_tempfile
echo "  IF CRU_proper_version = 0 THEN" >> create_update_tempfile
echo "    RAISE_APPLICATION_ERROR(-20737,'Invalid starting schema version.');" >> create_update_tempfile
echo "  END IF;" >> create_update_tempfile
echo "  SELECT set_schema_version($majornumber, $minornumber, $update_version, '$releasedate', 0) INTO CRU_temp FROM DUAL;" >> create_update_tempfile
echo "END;" >> create_update_tempfile
echo "/" >> create_update_tempfile
echo " -- *** Autogenerated Header Completed ***" >> create_update_tempfile
echo >> create_update_tempfile
cat $patchname >> create_update_tempfile
echo >> create_update_tempfile
echo " -- *** Begin Autogenerated Footer ***" >> create_update_tempfile
echo "DECLARE" >> create_update_tempfile
echo "  CRU_temp NUMBER;" >> create_update_tempfile
echo "BEGIN" >> create_update_tempfile
echo "  SELECT set_schema_version($majornumber, $minornumber, $update_version, '$releasedate', 1) INTO CRU_temp FROM DUAL;" >> create_update_tempfile
echo "END;" >> create_update_tempfile
echo "/" >> create_update_tempfile
echo " -- *** Autogenerated Footer Completed ***" >> create_update_tempfile
echo >> create_update_tempfile

mv "create_update_tempfile" "$update_filename"
if [ $update_version -eq 0 ]
then
  echo "Now cvs add \"$update_filename\" and cvs commit to complete the process."
else
  echo "Done."
fi

