-- select create_keyer('tablet', 'Burak', 'Ozyurt', 'iozyurt@ucsd.edu');

create or replace function create_keyer(varchar, varchar, varchar, varchar) returns integer as '
declare
  keyer_name_in alias for $1;
  first_name_in alias for $2; 
  last_name_in alias for $3;
  email_in alias for $4;
  du_cur cursor for select uniqueid from nc_databaseuser where
     name = keyer_name_in and
     userclass=(select uniqueid from nc_userclass where name=''data processing'');
  owner_cur cursor for select uniqueid from nc_databaseuser where 
     name=''ADMIN'' and isgroup = false and
      userclass=(select uniqueid from nc_userclass where name=''admin'');
  keyer_id numeric := -1;
  person_id numeric := -1;
  owner_id numeric := -1;
begin
   person_id := get_person_id(first_name_in, last_name_in, email_in) ;
   raise notice ''first name:% last_name:% email:%'', first_name_in, last_name_in, email_in;
   raise notice ''create keyer person_id:%'', person_id;

   open owner_cur;
   fetch owner_cur into owner_id;
   if owner_id is NULL then
       owner_id := -1;
   end if;
   close owner_cur;
   raise notice ''owner id:%'', owner_id;
   
 if person_id < 0 then
   person_id := nextval(''uid_seq'');
   insert into nc_person (uniqueid,tableid,owner,
        modtime,moduser,first_name, last_name, email)
     values(person_id, get_table_id(''nc_person''), owner_id,
       now(), owner_id, first_name_in,
        last_name_in, email_in);
 end if;
 open du_cur;
 loop
   fetch du_cur into keyer_id;
   if keyer_id is NULL then
     keyer_id := -1;
     exit;
   end if;
 end loop;
 close du_cur;
 if keyer_id = -1 then
   keyer_id :=  nextval(''uid_seq'');
   insert into nc_databaseuser ( uniqueid,name,tableid,
            owner, modtime, moduser, userclass,userstatus,
            isgroup, personid)
     values(keyer_id,
            UPPER(keyer_name_in),
            get_table_id(''nc_databaseuser''), owner_id,
             now(), owner_id,
            (select uniqueid from nc_userclass where name=''data processing''),
            (select uniqueid from nc_userstatus where userstatus=''active''),
             false,
             person_id);
 end if;
 return 0;

END;
' LANGUAGE plpgsql;
