drop table nc_assessmentscore ;

create table nc_assessmentscore(
    assessmentid              bigint    not null,
    scorename                 varchar(128)    not null,
    scoresequence             bigint    not null,
    scoretype                 varchar(64)     not null,
    tableid                   bigint    not null,
    uniqueid                  bigint    not null,
    owner                     bigint    not null,
    modtime timestamp not null,
    moduser                   bigint    not null,
    defaultvalue              varchar(255),
    nullable                  boolean     not null,
    scorelevel                bigint    not null,
    parentasid                bigint,
    parentscore               varchar(128),
    assessmentontology        varchar(128)    not null,
    assessmentconcept         varchar(64)     not null,
    securityclassification    varchar(128)    not null,
    minanswers                bigint,
    maxanswers                bigint,
    isrequired                boolean,
    isexcluded                boolean,
    isnew                     boolean,
    ismodified                boolean,
    description               text,
    constraint nc_assessmentscore_pk primary key (assessmentid, scorename) ,
    constraint nc_assessmentscore_sk  unique (uniqueid, tableid) );

-- comment on column nc_assessmentscore.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentscore.scorename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentscore.scoresequence is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentscore.scoretype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_assessmentscore.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_assessmentscore.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentscore.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentscore.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_assessmentscore.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentscore.defaultvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmentscore.nullable is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentscore.scorelevel is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentscore.parentasid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentscore.parentscore is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentscore.assessmentontology is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentscore.assessmentconcept is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_assessmentscore.securityclassification is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentscore.minanswers is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentscore.maxanswers is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentscore.isrequired is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentscore.isexcluded is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentscore.isnew is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentscore.ismodified is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentscore.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

