drop table nc_measurementunit ;

create table nc_measurementunit(
    measurementsystem    varchar(128)     not null,
    unit                 varchar(64)      not null,
    uniqueid             bigint     not null,
    tableid              bigint     not null,
    owner                bigint     not null,
    modtime timestamp not null,
    moduser              bigint     not null,
    measurementtype      varchar(128)     not null,
    conversionsystem     varchar(128),
    conversionunit       varchar(64)      not null,
    conversioninfo       varchar(1024),
    description          text,
    constraint nc_measurementunit_pk primary key (measurementsystem, unit) ,
    constraint nc_measurementunit_sk  unique (uniqueid, tableid) );

-- comment on column nc_measurementunit.measurementsystem is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_measurementunit.unit is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_measurementunit.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_measurementunit.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_measurementunit.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_measurementunit.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_measurementunit.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_measurementunit.measurementtype is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_measurementunit.conversionunit is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_measurementunit.conversioninfo is 'the conversioninfo column contains the necessary formula to describe how to convert the measurement unit described by the tuple to the default (i.e. reference) unit.' ;

-- comment on column nc_measurementunit.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

