drop table nc_researchsubject ;

create table nc_researchsubject(
    subjectid        varchar(64)     not null,
    uniqueid         bigint,
    tableid          bigint    not null,
    owner            bigint    not null,
    modtime timestamp not null,
    moduser          bigint    not null,
    extensionname    varchar(128)     default 'researchsubject' not null,
    speciesid        bigint    not null,
    constraint nc_researchsubject_pk primary key (subjectid) ,
    constraint nc_researchsubject_sk  unique (uniqueid, tableid) );

-- comment on column nc_researchsubject.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_researchsubject.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_researchsubject.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_researchsubject.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_researchsubject.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_researchsubject.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_researchsubject.extensionname is 'the name of the research subject type.' ;

-- comment on column nc_researchsubject.speciesid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

