DROP TABLE nc_assessment CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessment 
--

CREATE TABLE nc_assessment(
    assessmentID            NUMBER(38, 0)    NOT NULL,
    tableID                 NUMBER(38, 0)    NOT NULL,
    owner                   NUMBER(38, 0)    NOT NULL,
    modTime                 DATE             NOT NULL,
    modUser                 NUMBER(38, 0)    NOT NULL,
    previousAssessmentID    NUMBER(38, 0),
    name                    VARCHAR2(128),
    description             CLOB,
    uniqueID                NUMBER(38, 0),
    CONSTRAINT nc_assesment_pk PRIMARY KEY (assessmentID)
 		USING INDEX
 		(CREATE INDEX nc_assessment_pidx on nc_assessment(assessmentID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessment_sk  UNIQUE (assessmentID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessment_sidx on nc_assessment(assessmentID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON TABLE nc_assessment IS 'The assessment table defines an assessment instrument or measure (e.g. the Edinburgh Handedness Scale).  This is the root object for each assessment.'
;
COMMENT ON COLUMN nc_assessment.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessment.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessment.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessment.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_assessment.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessment.previousAssessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessment.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessment.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessment.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
