DROP TABLE nc_measurementUnit CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_measurementUnit 
--

CREATE TABLE nc_measurementUnit(
    measurementSystem    VARCHAR2(128)     NOT NULL,
    unit                 VARCHAR2(64)      NOT NULL,
    uniqueID             NUMBER(38, 0)     NOT NULL,
    tableID              NUMBER(38, 0)     NOT NULL,
    owner                NUMBER(38, 0)     NOT NULL,
    modTime              DATE              NOT NULL,
    modUser              NUMBER(38, 0)     NOT NULL,
    measurementType      VARCHAR2(128)     NOT NULL,
    conversionSystem     VARCHAR2(128),
    conversionUnit       VARCHAR2(64)      NOT NULL,
    conversionInfo       VARCHAR2(1024),
    description          CLOB,
    CONSTRAINT nc_measurementUnit_pk PRIMARY KEY (measurementSystem, unit)
 		USING INDEX
 		(CREATE INDEX nc_measurementUnit_pidx on nc_measurementUnit(measurementSystem, unit)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_measurementUnit_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_measurementUnit_sidx on nc_measurementUnit(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_measurementUnit.measurementSystem IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_measurementUnit.unit IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_measurementUnit.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementUnit.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_measurementUnit.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementUnit.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_measurementUnit.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementUnit.measurementType IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_measurementUnit.conversionUnit IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_measurementUnit.conversionInfo IS 'The conversionInfo column contains the necessary formula to describe how to convert the measurement unit described by the tuple to the default (i.e. reference) unit.'
;
COMMENT ON COLUMN nc_measurementUnit.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
