drop table bk_tupleaccess ;

create table bk_tupleaccess(
    tupleid       bigint    not null,
    tableid       bigint    not null,
    grantee       bigint    not null,
    grantor       bigint    not null,
    modtime timestamp not null,
    owner         bigint    not null,
    moduser       bigint    not null,
    can_read      boolean     not null,
    can_write     boolean     not null,
    can_delete    boolean     not null,
    can_admin     boolean     not null,
    constraint bk_tupleaccess_pk primary key (tupleid, tableid, grantee, grantor, modtime) ,
    constraint bk_tupleaccess_sk  unique (tupleid, tableid) );

-- comment on table bk_tupleaccess is 'the bk_tupleaccess table stores all modified and/or deleted permissions from the nc_tupleaccess table.  this allows for complete audit trail of permissions changes within the database.' ;

-- comment on column bk_tupleaccess.tupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column bk_tupleaccess.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column bk_tupleaccess.grantee is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column bk_tupleaccess.grantor is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column bk_tupleaccess.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column bk_tupleaccess.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column bk_tupleaccess.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column bk_tupleaccess.can_read is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column bk_tupleaccess.can_write is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column bk_tupleaccess.can_delete is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column bk_tupleaccess.can_admin is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

