drop table nc_transformationargument ;

create table nc_transformationargument(
    uniqueid       bigint    not null,
    tableid        bigint    not null,
    owner          bigint    not null,
    modtime timestamp not null,
    moduser        bigint    not null,
    argname        varchar(128),
    transformid    bigint    not null,
    optional       boolean       default true not null,
    constraint nc_transformationargument_pk primary key (uniqueid) ,
    constraint nc_transformationargument_sk  unique (uniqueid, tableid) );

-- comment on column nc_transformationargument.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_transformationargument.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_transformationargument.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_transformationargument.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_transformationargument.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_transformationargument.argname is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_transformationargument.transformid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_transformationargument.optional is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

