#!/bin/sh
####################################################
#  Script to run cold backups.
#
#  Use:  ./backupCold.sh oracle_sid config_file.cfg
#
#  
#
####################################################

SID=$1
CFG=$2

####################################################
# Grabs all the relevant variables from the config file
####################################################

OracLE_BASE=`cat $CFG | grep "ORACLE_BASE" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
export ORACLE_HOME=`cat $CFG | grep "ORACLE_HOME" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
export TNSADMIN=/dbms/oracle/v01/app/oracle/product/10.2.0/network/admin
export ARCH_BU_DIR=`cat $CFG | grep "ARCH_BU_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
export LD_LIBRARY_PATH=$ORACLE_HOME/lib
SQLPLUS_DIR=$ORACLE_HOME/bin
DBBACKUP=`ps -ef | grep "backupCOLD.sh $SID" | grep -v grep`
BASE_COLD_BU_DIR=`cat $CFG | grep "BASE_COLD_BU_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
BU_COLD_DIR=`cat $CFG | grep "BACKUP_COLD_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
RESPONSE_TEAM=`cat $CFG | grep "RESPONSE_TEAM" | grep -v "#" | gawk -F= '{gsub(/[\(\)\",]/," ",$2); print $2}'`
DAY=`date +%d`
PROG_DIR=`cat $CFG | grep "PROG_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"*[:space:]*]/,"",$2); print $2}'`
PROG=$PROG_DIR/dbbackup.pl
LOG_FILE=$PROG_DIR/dbbackup_COLD_$SID.log
LOG_FILE_BU=$PROG_DIR/dbbackup_COLD_$SID.log.bu
MONTHLY=0
ALERT=90
DATABASE_URL=`cat $CFG | grep "DATABASE_URL" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SRB_PATH=`cat $CFG | grep "SRB_PATH" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SITE_NAME=`cat $CFG | grep "SITE_NAME" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SDIR=/usr/local/bin
ARCH_RETENTION=`cat $CFG | grep "ARCH_RETENTION" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`

######################################################
#  Checks to see if there is space for writing out the
#  backups and fails (and sends an email warning) if
#  there isn't.
######################################################
df -H $BASE_COLD_BU_DIR $BASE_BU_DIR | grep -vE '^Filesystem|tmpfs|cdrom' | awk '{print $5 " " $1 }' | while read output;
do
usep=$(echo $output | awk '{print $1}' | cut -d'%' -f1 )
partition=$(echo $output | awk '{ print $2 }' )

if [ $usep -ge $ALERT ]; then
  echo "CRITICAL Running out of space \"$partition ($usep%)\" on $(hostname) on $(date)" |

  mail -s "CRITICAL Alert: Almost out of disk space $usep" $RESPONSE_TEAM

else

    printf "`date '+%D %T'`\tWeekly COLD dbbackup started for hidprd\n" >> $LOG_FILE

    export ORACLE_SID=$SID
    
    #######################################################
    #  Creates a shutdown script for oracle, executes it
    #  and then deletes it.
    #######################################################
    echo "alter system checkpoint;
    shutdown abort; 
    startup restrict; 
    shutdown immediate;
    exit" > temp_stop.sql
    
    $SQLPLUS_DIR/sqlplus "/ as sysdba" @ temp_stop.sql

    rm -rf temp_stop.sql
    
    ####################################################
    #  Copies all the relevant files to the cold temp
    #  backup directory.
    ####################################################
    printf "`date '+%D %T'`\tWeekly COLD dbbackup for hidprd - database shut down.\n" >> $LOG_FILE
    cp -rp /dbms/oracle/v02/oradata/hidprd/*          $BU_COLD_DIR
    #cp -rp /dbms/oracle/v02/oradata/hidprd/arch/*.arc $BU_COLD_DIR/arch
    cp -rp /dbms/oracle/v03/oradata/hidprd/*          $BU_COLD_DIR
    cp -rp $ARCH_BU_DIR/*.arc 			      $BU_COLD_DIR/arch
    cp -rp /dbms/oracle/v04/oradata/hidprd/*          $BU_COLD_DIR
    cp -rp /dbms/oracle/v05/oradata/hidprd/*          $BU_COLD_DIR
    cp -rp /dbms/oracle/v06/oradata/hidprd/*          $BU_COLD_DIR
    cp -rp /dbms/oracle/v09/oradata/hidprd/*          $BU_COLD_DIR
    cp -rp $ORACLE_HOME/dbs/*hidprd*.ora              $BU_COLD_DIR
    cp -rp $ORACLE_HOME/dbs/*pfile*.ora               $BU_COLD_DIR
    cp -rp  ~/admin/hidprd/                           $BU_COLD_DIR
    #cp -rp $TNS_ADMIN/listener.ora                    $BU_COLD_DIR
    #cp -rp $TNS_ADMIN/sqlnet.ora                      $BU_COLD_DIR
    #cp -rp $TNS_ADMIN/tnsnames.ora                    $BU_COLD_DIR
    
    ####################################################
    #  Create a startup script for the database, execute
    #  it, and then delete it.
    ####################################################
    echo "startup;
    exit" > temp_start.sql
    
    $SQLPLUS_DIR/sqlplus "/ as sysdba" @temp_start.sql
    
    rm -rf temp_start.sql
    
    
    printf "`date '+%D %T'`\tWeekly COLD dbbackup for hidprd - database restarted.\n" >> $LOG_FILE

    ####################################################
    #  Checks which week the backup is running during
    #  and creates a copy in the appropriate weekly
    #  directory and if it's the first week an additional
    #  copy in the monthly directory.
    ####################################################
    if [ $DAY -ge 1 -a $DAY -lt 8 ]; then
	TARGET_DIR=$BASE_COLD_BU_DIR/weekly/one
	MONTHLY=1
    elif [ $DAY -ge 8 -a $DAY -lt 15 ]; then
	TARGET_DIR=$BASE_COLD_BU_DIR/weekly/two
    elif [ $DAY -ge 15 -a $DAY -lt 22 ]; then
	TARGET_DIR=$BASE_COLD_BU_DIR/weekly/three
    else
	TARGET_DIR=$BASE_COLD_BU_DIR/weekly/four
    fi
    

    ####################################################
    #  Remove the old backup and tar up the current one,
    #  put it in the right directory, and gzip it. 
    ####################################################
    rm -rf $TARGET_DIR/*
    tar -cvf $TARGET_DIR/hidprd_`date '+%d%b%Y'`.tar $BU_COLD_DIR > /tmp/tar 2> /tmp/tar_error 
    printf "`date '+%D %T'`\tTarball created for COLD hidprd\n" >> $LOG_FILE
    gzip $TARGET_DIR/*
    printf "`date '+%D %T'`\tTarball gzipped for COLD hidprd\n" >> $LOG_FILE
    
    ###########################################################################
    # Need to find and delete all archive log files a number of days older than
    # the supplied retention number.
    ##########################################################################

    find $BU_COLD_DIR/arch -type f -mtime +$ARCH_RETENTION -exec rm {} ';'

    ####################################################
    #  Create the xml output file and put it in the SRB
    ####################################################
    TIMESTAMP=`date --iso-8601='minutes'`
    ARCHIVE_FILE="$SITE_NAME"_"$TIMESTAMP"_status.xml
    XML_LOG=/tmp/"$ARCHIVE_FILE"
    VERSION=`sqlplus -s "system/$P" << _EOF_
            set heading off;
            set feedback off;
            set verify off;
            select v.majorversion || '_' || v.minorversion || '_' || v.updateversion from (select * from nc_schemaversion where updatefinished = 1 order by majorversion, minorversion, updateversion)v where rownum < 2;
            exit;
   _EOF_
   `
    
    printf "<birn_status>\n <date_time>$TIMESTAMP" >>$XML_LOG
    printf "</date_time>\n <database_archive>\n  <database_url>" >>$XML_LOG
    printf "$DATABASE_URL</database_url>\n" >> $XML_LOG
    printf "  <cold_backup>\n" >> $XML_LOG
    printf "   <status>complete</status>\n" >> $XML_LOG
    printf "   <archive_url>"$SRB_PATH"/$ARCHIVE_FILE</archive_url>\n" >> $XML_LOG
    printf "  <version>$VERSION</version>\n" >> $XML_LOG
    printf "  </cold_backup>\n" >> $XML_LOG
    printf " <database_archive>\n" >> $XML_LOG
    printf "</birn_status>\n" >> $XML_LOG
    
    $SDIR/Sinit
    $SDIR/Sput $XML_LOG $SRB_PATH
    $SDIR/Schmod r human groups "$SRB_PATH"/"$ARCHIVE_FILE"
    
    ####################################################
    #  If it's the 1st week, copy the cold backup
    ####################################################
    if [ $MONTHLY == 1 ]; then
	rm -rf $BASE_COLD_BU_DIR/monthly/`date '+%b'`/*.gz $BASE_COLD_BU_DIR/monthly/`date '+%b'`/*
	cp $TARGET_DIR/*.gz $BASE_COLD_BU_DIR/monthly/`date '+%b'`/
    fi
fi
done
