#!/bin/sh

##############################################################################
# dbbackup.sh
# Wrapper script for the dbbackup.pl program.
#
# Date      Author        Change description
# ----------------------------------------------------------------------------
# 05/01/03  Bobby Higbie  Initial Version
# 12/12/03  Bobby Higbie  Added *[:space:]* to PROG_DIR's regex.  This was raising
#                         runtime syntax errors while accessing LOG_FILE & RESTORE_FILE.
#                         Added #!/bin/bash to RESTORE_FILE header.
#                         Added chgrp dba to LOG_FILE & RESTORE_FILE.
# 03/10/04  Bobby Higbie  Checked for ERROR messages in log file.  Will notify
#                         group (in the config file) if errors occur.
#
##############################################################################

SID=$1
CFG=$2
#Setup Oracle environment for DBI
export ORACLE_BASE=`cat $CFG | grep "ORACLE_BASE" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
export ORACLE_HOME=`cat $CFG | grep "ORACLE_HOME" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
export LD_LIBRARY_PATH=$ORACLE_HOME/lib
DBBACKUP=`ps -ef | grep "dbbackup.pl $SID" | grep -v grep`
BASE_BU_DIR=`cat $CFG | grep "BASE_BU_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
BU_DIR=`cat $CFG | grep "BACKUP_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
PROG_DIR=`cat $CFG | grep "PROG_DIR" | grep -v "#" | gawk -F= '{gsub(/[\"*[:space:]*]/,"",$2); print $2}'`
RESPONSE_TEAM=`cat $CFG | grep "RESPONSE_TEAM" | grep -v "#" | gawk -F= '{gsub(/[\(\)\",]/," ",$2); print $2}'`
PROG=$PROG_DIR/dbbackup.pl
LOG_FILE=$PROG_DIR/dbbackup_$SID.log
LOG_FILE_BU=$PROG_DIR/dbbackup_$SID.log.bu
RESTORE_FILE=$BU_DIR/restore_$SID.sh
RESTORE_FILE_BU=$BU_DIR/restore_$SID.sh.bu
DATABASE_URL=`cat $CFG | grep "DATABASE_URL" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SRB_PATH=`cat $CFG | grep "SRB_PATH" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SITE_NAME=`cat $CFG | grep "SITE_NAME" | grep -v "#" | gawk -F= '{gsub(/[\"[:space:]]/,"",$2); print $2}'`
SDIR=/usr/local/bin


if [ "$DBBACKUP" != "" ]; 
then
 printf "$DBBACKUP\n"
 printf "`date '+%D %T'`\tWARN: dbbackup is already running\n" >> $LOG_FILE
else
 #Log file maintenance
 if [ -f $LOG_FILE_BU ] ;
 then
   rm $LOG_FILE_BU
 fi
 if [ -f $LOG_FILE ] ;
 then
   mv $LOG_FILE $LOG_FILE_BU
 fi

 #dbbackup can only execute successfully with a config file
 if [ ! -f $CFG ];
 then
   printf "`date '+%D %T'`\t$CFG not found for $1\n" >> $LOG_FILE
   exit 1
 fi

 #Restore file maintenance
 if [ -f $RESTORE_FILE_BU ] ;
 then
   rm $RESTORE_FILE_BU
 fi
 if [ -f $RESTORE_FILE ] ;
 then
   mv $RESTORE_FILE $RESTORE_FILE_BU 
 fi

 printf "`date '+%D %T'`\tdbbackup is started for $SID\n" >> $LOG_FILE

 #Create restore file for database
 printf "#!/bin/bash\n" >> $RESTORE_FILE
 printf "#\n" >> $RESTORE_FILE
 printf "#############################################################\n" >> $RESTORE_FILE
 printf "# Restore script for $1. Uncomment lines to restore files.#\n" >> $RESTORE_FILE
 printf "#############################################################\n" >> $RESTORE_FILE
 printf "#\n" >> $RESTORE_FILE
 printf "#\n" >> $RESTORE_FILE
 printf "#\n" >> $RESTORE_FILE
 chmod 640 $LOG_FILE
 chgrp dba $LOG_FILE
 chmod 750 $RESTORE_FILE
 chgrp dba $RESTORE_FILE

 perl $PROG $SID $CFG
 ERRMSG=`grep ERROR: $LOG_FILE`;
 TIMESTAMP=`date --iso-8601='minutes'`
 ARCHIVE_FILE="$SITE_NAME"_"$TIMESTAMP"_status.xml
 XML_LOG=/tmp/"$ARCHIVE_FILE"
 
 if [ "$ERRMSG" != "" ];
 then
   printf "$SID backup failed:\n\n$ERRMSG" | mail -s "CRITICAL:DBBACKUP:backup_failed" $RESPONSE_TEAM

  printf "<birn_status>\n <date_time>$TIMESTAMP" >>$XML_LOG
  printf "</date_time>\n <database_archive>\n  <database_url>" >>$XML_LOG
  printf "$DATABASE_URL</database_url>\n" >> $XML_LOG
  printf "  <hot_backup>\n" >> $XML_LOG
  printf "   <status>FAILED</status>\n" >> $XML_LOG
  printf "   <archive_url>"$SRB_PATH"/$ARCHIVE_FILE</archive_url>\n" >> $XML_LOG
  printf "  <version>1.0</version>\n" >> $XML_LOG
  printf "  </hot_backup>\n" >> $XML_LOG
  printf " <database_archive>\n" >> $XML_LOG
  printf "</birn_status>\n" >> $XML_LOG

 else
  printf "`date '+%D %T'`\tDaily dbbackup started for hidprd\n" >> $LOG_FILE
  rm -rf $BASE_BU_DIR/`date '+%a'`/*
  tar -cvf $BASE_BU_DIR/`date '+%a'`/hidprd_`date '+%d%b%Y'`.tar $BU_DIR > /tmp/tar 2> /tmp/tar_error
  printf "`date '+%D %T'`\tTarball created for hidprd\n" >> $LOG_FILE
  gzip $BASE_BU_DIR/`date '+%a'`/*
  printf "`date '+%D %T'`\tTarball gzipped for hidprd\n" >> $LOG_FILE
  printf "`date '+%D %T'`\tDaily dbbackup ended for hidprd\n" >> $LOG_FILE

  printf "<birn_status>\n <date_time>$TIMESTAMP" >>$XML_LOG
  printf "</date_time>\n <database_archive>\n  <database_url>" >>$XML_LOG
  printf "$DATABASE_URL</database_url>\n" >> $XML_LOG
  printf "  <hot_backup>\n" >> $XML_LOG
  printf "   <status>complete</status>\n" >> $XML_LOG
  printf "   <archive_url>"$SRB_PATH"/$ARCHIVE_FILE</archive_url>\n" >> $XML_LOG
  printf "  <version>1.0</version>\n" >> $XML_LOG
  printf "  </hot_backup>\n" >> $XML_LOG
  printf " <database_archive>\n" >> $XML_LOG
  printf "</birn_status>\n" >> $XML_LOG

 fi

 $SDIR/Sinit
 $SDIR/Sput $XML_LOG $SRB_PATH
 $SDIR/Schmod r human groups "$SRB_PATH"/"$ARCHIVE_FILE"

fi
