#!/bin/sh

# Use for debugging
#
set -xv 
#

# Set up base env variables
#
export TIMESTAMP=`date +%m%d%Y_%H_%m`
export ORACLE_SID=hidprd
export ORACLE_BASE=/dbms/oracle/v01/app/oracle
export ORACLE_HOME=/dbms/oracle/v01/app/oracle/product/10.2.0

/bin/echo $TIMESTAMP
/bin/echo "Setting up environment parameters"
###
#
# Set up key variables to refer to for load balancing of files
#
###
export ORACLE_SYSTEMFILE=/dbms/oracle/v02/oradata
export ORACLE_REDO=/dbms/oracle/v03/oradata
export ORACLE_DATA=/dbms/oracle/v04/oradata
export ORACLE_IDX=/dbms/oracle/v05/oradata
export ORACLE_TEMP=/dbms/oracle/v06/oradata
export ORACLE_ARCH=/dbms/oracle/v07/oradata
export ORACLE_BACKUP=/dbms/oracle/v08/backup
export ORACLE_REDO2=/dbms/oracle/v09/oradata
###

/bin/echo "Create the oracle password file" 
$ORACLE_HOME/bin/orapwd file=/dbms/oracle/v01/app/oracle/product/10.2.0/dbs/orapwhidprd password=h1dd8n

ret_val=$?

$ORACLE_HOME/bin/sqlplus /nolog @$ORACLE_BASE/admin/hidprd/create/create_db_hidprd.sql
$ORACLE_HOME/bin/sqlplus /nolog @$ORACLE_BASE/admin/hidprd/create/create_dbfiles_hidprd.sql
# Catalog does not run catqm... best though to run xdb install from media and runInstaller
# Doesn't look to be all there, and the gui createdb will automate it and find resource settings and dependencies
$ORACLE_HOME/bin/sqlplus /nolog @$ORACLE_BASE/admin/hidprd/create/create_db_catalog.sql
$ORACLE_HOME/bin/sqlplus /nolog @$ORACLE_BASE/admin/hidprd/create/create_user_and_grants.sql
$ORACLE_HOME/bin/sqlplus /nolog @$ORACLE_BASE/admin/hidprd/create/create_ops_oracle_admin.sql;

ret_val=$?

/bin/echo "You will have to install perfstat with $ORACLE_HOME/rdbms/admin/spcreate.sql"

/bin/echo "This enables the ability to trace SQL with autotrace -- birnweb user granted it"
$ORACLE_HOME/bin/sqlplus "/ as sysdba" @$ORACLE_BASE/admin/hidprd/create/create_plustrc_role_explainplan.sql;

/bin/echo "Create a spfile from the inithidprd.ora file (minus MTS, and replication) "
$ORACLE_HOME/bin/sqlplus "/ as sysdba" @$ORACLE_BASE/admin/hidprd/create/postDBCreation.sql

/bin/echo "Java install happens after catalog (added user creates and perfstat first becz this requires startup mount"
$ORACLE_HOME/bin/sqlplus /nolog <<EOF
connect system/b1rn8n as sysdba;
spool /dbms/oracle/v01/app/oracle/admin/hidprd/create/logs/jvm_shutdown_startup_mount_for_install.log
whenever sqlerror exit 1
whenever oserror exit 2
shutdown immediate;
spool off;
@$ORACLE_BASE/admin/hidprd/create/full_jvminst_920.sql
spool off;
exit;
EOF

/bin/echo "Rebuild any invalidated objects ; recompile them after the installation of Java "
$ORACLE_HOME/bin/sqlplus /nolog <<EOF
connect system/b1rn8n as sysdba;
spool /dbms/oracle/v01/app/oracle/admin/hidprd/create/logs/startup_and_object_recompile.log
startup;
@$ORACLE_HOME/rdbms/admin/utlrp.sql
spool off;
exit;
EOF

ret_val=$?

# Exit the script itself
exit;
