DOC 
This script creates an ops$oracle username and assumes that oracle
is in the /etc/passwd file.
This allows the oracle user to administer without having a username
and password typed at the command line prompt in the clear.
And it relies on UNIX authentication for oracle. I.e. the oracle
unix account password is what is used to login to both UNIX and the
oracle database via sqlplus. Then connection is made by typing sqlplus /
#
connect system/b1rn8n as sysdba;

spool $ORACLE_BASE/admin/$ORACLE_SID/create/logs/create_ops_user.log
set echo on;
whenever sqlerror exit 1
whenever oserror exit 2
set heading on;
CREATE USER OPS$oracle IDENTIFIED EXTERNALLY;
GRANT CREATE SESSION to OPS$ORACLE;
GRANT RESOURCE to OPS$ORACLE;
GRANT IMP_FULL_DATABASE to ops$oracle;
GRANT EXP_FULL_DATABASE to ops$oracle;
GRANT SELECT ANY DICTIONARY to ops$oracle;

select 'This is now how it is defined in the dba_users table' from dual;
select * from dba_users where username ='OPS$ORACLE';
spool off;
exit;
