#!/usr/bin/perl 

use strict;
use warnings;

sub extract_objecttypeids {
   my ($sql_file) = @_;
   open(IN, "$sql_file") or die("cannot open file:$sql_file:$!");
   my %map = (); 

   while(<IN>) {
      chomp;
      if (/^insert into NC_DATAOBJECTTYPE /) {
	 if ( /values\(([^\)]+)\)/ ) {
	    my $s = $1;
	    my @toks = split(/,/,$s);
	    $map{ $toks[5] } = $toks[0];
	 }
      }
   }
   close(IN);
   return %map;
}


sub fix_objecttype_recs {
   my ($sql_file, $map_ref) = @_;
   my $out_file = "${sql_file}.fixed";
   open(OUT,">$out_file") or die("cannot create file:$out_file:$!");
   open(IN, "$sql_file") or die("cannot open file:$sql_file:$!");
   while(<IN>) {
      chomp;
      unless (/^insert into NC_DATAOBJECT /) {
	 print OUT "$_\n";
	 next;
      }
      my $line = $_;
      if ( $line =~ /^insert into NC_DATAOBJECT \(([^\)]+)\)/) {
	 my $col_str = $_;
	 my @ct_arr = split(/,/,$col_str);
	 my $idx = 0;
	 foreach my $ct (@ct_arr) {
	    last if ($ct eq "OBJECTTYPE");
	    $idx++;
	 }
	 $line =~ s/OBJECTTYPE,/OBJECTTYPEID,/; 
	 if (/values\(([^\)]+)\)/ ) {
	    my $s = $1;
	    my @toks = split(/,/,$s);
	    $line =~ s/values\(.+\);//;
	    my $ot_str = '';
	    $ot_str =$toks[$idx] if ($idx < @toks);
	    my $fixed = 0;
	    if (exists $map_ref->{$ot_str}) {
	       $toks[$idx] = $map_ref->{$ot_str};
	       $fixed = 1;
	    }
	    $line .= "values(" . join(",",@toks) . ");";
	    print "$line\n" if ($fixed);
	    print OUT "$line\n";
	 }
      }
   }
   close(IN);
   close(OUT);
   print "wrote corrected file to:$out_file\n";
}

sub usage() {
   die<<EOS

Usage: $0 <db_export.sh generated sql-file>

EOS
}

usage() unless (@ARGV == 1);

my $sql_file = shift @ARGV; 

my %map = extract_objecttypeids($sql_file);

fix_objecttype_recs($sql_file, \%map);





