package dbutils;


public class ForeignKey {
    protected String name;
    protected String pkName;
    protected String pkTable;
    protected String fkTable;
    protected String[] pkColumns;
    protected String[] fkColumns;
    protected int deleteRule;
    protected String updateRule;
    protected int colCount = 0;

    public ForeignKey(String fkName, String fkTable) {
      this.name = fkName;
      this.fkTable = fkTable;
      int maxCols = 10;
      pkColumns = new String[maxCols];
      fkColumns = new String[maxCols];
    }

    public ForeignKey(String fkName, String pkName, String pkTable, String fkTable, int maxCols, int deleteRule) {
      this.name = fkName;
      this.pkName = pkName;
      this.pkTable = pkTable;
      this.fkTable = fkTable;
      pkColumns = new String[maxCols];
      fkColumns = new String[maxCols];
      this.deleteRule = deleteRule;
    }

    public void addPkColumn(String colName, int idx) {
      pkColumns[idx] = colName;
    }

    public void addFkColumn(String colName, int idx) {
      fkColumns[idx] = colName;
    }

    public int getColumnCount() {
      for (int i = 0; i < fkColumns.length; i++) {
        if (fkColumns[i] == null)
          return i;
      }
      return fkColumns.length;
    }

    public String toForeignKey() {
      colCount = getColumnCount();
      StringBuffer buf = new StringBuffer(256);
      buf.append("alter table ").append(fkTable).append(" add constraint ").append(name);
      buf.append(" foreign key (");
      for (int i = 0; i < colCount; i++) {
        buf.append( fkColumns[i]);
        if ( (i+1) < colCount)
          buf.append(',');
      }
      buf.append(") references ").append(pkTable).append('(');
      for (int i = 0; i < colCount; i++) {
        buf.append( pkColumns[i]);
        if ( (i+1) < colCount)
          buf.append(',');
      }
      buf.append(")");

      return buf.toString();
    }

    public String toDropForeignKey() {
      StringBuffer buf = new StringBuffer(256);
      buf.append("alter table ").append(fkTable).append(" drop constraint ").append(name);

      return buf.toString();
    }


  //---------------------- setters --------------
  public void setName(String newName) { this.name = newName; }
  public void setPkName(String newPkName) { this.pkName = newPkName; }
  public void setPkTable(String newPkTable) { this.pkTable = newPkTable; }
  public void setFkTable(String newFkTable) { this.fkTable = newFkTable; }
  public void setDeleteRule(int newDeleteRule) { this.deleteRule = newDeleteRule; }
  public void setUpdateRule(String newUpdateRule) { this.updateRule = newUpdateRule; }
  public void setColCount(int newColCount) { this.colCount = newColCount; }
  //---------------------- getters --------------
  public String getName() { return this.name; }
  public String getPkName() { return this.pkName; }
  public String getPkTable() { return this.pkTable; }
  public String getFkTable() { return this.fkTable; }
  public int getDeleteRule() { return this.deleteRule; }
  public String getUpdateRule() { return this.updateRule; }
  public int getColCount() { return this.colCount; }


}