package dbutils;

import java.io.*;
import java.util.*;

/**
 *
 * @version $Id: GenUtils.java,v 1.1.1.1 2005/10/25 18:32:59 bozyurt Exp $
 * @author I. Burak Ozyurt
 */

public class GenUtils {

  protected GenUtils() {}


  public static Properties loadProperties(String propsFilename) throws IOException
  {
     InputStream is = GenUtils.class.getClassLoader().getResourceAsStream(propsFilename);
     Properties props = new Properties();
     props.load(is);

     return props;
  }

  public static Number toNumber(String value) {
    Number num = null;
    try {
       num = Integer.valueOf(value);
    } catch(NumberFormatException nfe) {
       try {
         num = Float.valueOf(value);
       }catch(NumberFormatException e) {
         num = null;
       }
    }
    return num;
  }

  public static String getUniqueFile(String filename) {
    File f = new File(filename);
    int count = 0;
    String newFilename = filename;
    while (f.exists()) {
      ++count;
      newFilename = filename + "." + count;
      f = new File(newFilename);
    }
    return newFilename;
  }


  public static void serialize(Object o, String filename) throws IOException {
    // assert(o != null);
    ObjectOutputStream out = null;
    try {

      String newFilename = getUniqueFile(filename);
      if (!newFilename.equals(filename) ) {
        File f = new File(filename);
        boolean ok = f.renameTo(new File(newFilename));
        if (!ok) {
          System.err.println("Cannot rename "+ filename + " to " + newFilename + "!");
        }
      }
      out = new ObjectOutputStream(  new BufferedOutputStream(
          new FileOutputStream(filename), 4096) );
      out.writeObject(o);
    } finally {
      if ( out != null) try { out.close(); } catch(Exception x) {}
    }
  }

  public static Object deserialize(String filename) throws IOException, ClassNotFoundException {
    // assert(filename != null && new File(filename).isFile());
    ObjectInputStream in = null;
    try {
       in = new ObjectInputStream( new BufferedInputStream( new FileInputStream(filename), 4096) );
       Object o = in.readObject();
       return o;
    } finally {
      if ( in != null) try { in.close(); } catch(Exception x) {}
    }
  }

  public static String getBasePart(String filename) {
    if (filename == null)
       return null;
    int idx = filename.lastIndexOf('.');
    if (idx == -1)
        return filename;
    return filename.substring(0, idx);
  }
}
