package dbutils;

import java.io.*;
import java.sql.*;
import java.util.*;

public class InsertStatementFixer {
  Tokenizer tokenizer;
  Map tableClobMap = new HashMap();
  String usr, pwd, dbURL;
  Connection con;
  String currentTablename;

  public InsertStatementFixer(String filename, String propertiesFile) throws Exception {
    tokenizer = new Tokenizer(filename);
    Properties props = GenUtils.loadProperties(propertiesFile);

  this.usr = props.getProperty("user");
  this.pwd = props.getProperty("pwd");
  this.dbURL = props.getProperty("dburl");
  con = connect(dbURL, usr, pwd);
  System.out.println("connected to "+ dbURL);


  }

  protected Connection connect(String dbURL, String usr, String pwd) throws Exception {
    Class.forName("oracle.jdbc.driver.OracleDriver");
    return  DriverManager.getConnection(dbURL,usr,pwd);
  }

  public void shutdown() {
    if ( tokenizer != null)
      tokenizer.shutdown();

    if (con != null)
      try { con.close(); } catch(Exception x) {}
  }


   public void parse() throws Exception {
     int tc = -1;
     tc = tokenizer.getNextToken();
     while ( tc != Tokenizer.EOF) {
       if ( tc == Tokenizer.INSERT) {
         parseInsertStatement(tc);
       }
       tc = tokenizer.getNextToken();
     }
   }


  public void parseInsertStatement(int tc ) throws IOException {
    while( tc != Tokenizer.INSERT) {
      tc = tokenizer.getNextToken();
    }
    tc = tokenizer.getNextToken(); // consume into

    tc = tokenizer.getNextToken();
    String tableName = tokenizer.getStringValue();
    Map colMap = (Map) tableClobMap.get( tableName.toLowerCase());

    if ( this.currentTablename == null || !this.currentTablename.equals(tableName) ){
      System.out.println("-- " + tableName);
      System.out.println("-- ");
      this.currentTablename = tableName;
    }

    tc = tokenizer.getNextToken();
    String [] columnList = null;
    Object[] values = null;
    if ( tc == Tokenizer.LEFT_PAR) {
      columnList = parseColumnList();
    }

    tc = tokenizer.getNextToken();
    if ( tc == Tokenizer.VALUES ) {
      tc = tokenizer.getNextToken();
      values = parseValuesList();
    }
    tc = tokenizer.getNextToken(); // consume ;

    StringBuffer buf = new StringBuffer(256);
    buf.append("INSERT INTO ").append(tableName).append(" (");
    for (int i = 0; i < columnList.length; i++) {
      buf.append( columnList[i]);
      if ( (i + 1) < columnList.length)
        buf.append(',');
    }
    buf.append(") VALUES(");
    for (int i = 0; i < values.length; i++) {
      if ( colMap != null && colMap.get( columnList[i]) != null) {
         if ( values[i].equals("NULL") ) {
           buf.append("EMPTY_CLOB()");
         } else
           buf.append(values[i]);
      } else {
        buf.append(values[i]);
      }
      if ( (i + 1) < values.length)
        buf.append(',');
    }
    buf.append(");");

    System.out.println(buf.toString());
  }

  protected int indexOf(String val, String[] list) {
    for (int i = 0; i < list.length; i++) {
      if ( list[i].equals(val) )
        return i;
    }
    return -1;
  }

  protected String[] parseColumnList() throws IOException{
    int tc = -1;
    List colNames = new LinkedList();
    tc = tokenizer.getNextToken();
    while ( tc != -1 && tc != Tokenizer.RIGHT_PAR ) {
      if ( tc == Tokenizer.WORD)
        colNames.add( tokenizer.getStringValue() );

      tc = tokenizer.getNextToken();
    }
    String[] columnList = new String[ colNames.size() ];
    colNames.toArray(columnList);
    return columnList;
  }

  protected Object[] parseValuesList() throws IOException{
    int tc = -1;
    List values = new LinkedList();
    tc = tokenizer.getNextToken();
    while ( tc != -1 && tc != Tokenizer.RIGHT_PAR ) {
      if ( tc == Tokenizer.WORD)
        values.add( tokenizer.getStringValue() );
      else if ( tc == Tokenizer.STRING)
        values.add( "'" + tokenizer.getStringValue() + "'");
      else if ( tc == Tokenizer.TIMESTAMP) {
        tc = tokenizer.getNextToken();
        values.add( "TIMESTAMP '" + tokenizer.getStringValue() + "'");
      } else if ( tc == Tokenizer.NUMBER) {
        values.add( tokenizer.getNumber() );
      }

      tc = tokenizer.getNextToken();
    }
    return values.toArray();
  }


  public void getCLOBColumnInfos()  throws Exception {
    SchemaExtractor se = null;
    se = new SchemaExtractor(con);
    se.loadDBTables(usr.toUpperCase() );
    Iterator iter = se.getTables();
    while (iter.hasNext()) {
      DBTable table = (DBTable) iter.next();
      // skip non morph-birn tables
      if (!table.getName().toLowerCase().startsWith("nc_")) {
        iter.remove();
      }
    }

    iter = se.getTables();
    while (iter.hasNext()) {
      DBTable table = (DBTable) iter.next();
      for (Iterator it = table.getColumns().iterator(); it.hasNext(); ) {
        DBTable.DBColumn column = (DBTable.DBColumn)it.next();
        if ( column.getType().equalsIgnoreCase("clob") ) {
          // System.out.println("adding clob column "+ column.getName() + " for table " + table.getName());
          Map colMap = (Map) tableClobMap.get( table.getName().toLowerCase() );
          if ( colMap == null) {
            colMap = new HashMap(3);
            tableClobMap.put( table.getName().toLowerCase(), colMap);
          }
          colMap.put(column.getName(), column.getName());
        }
      }
    }
  }


  public static void main(String[] args) {
     InsertStatementFixer isf= null;
     String filename = "c:/cygwin/home/bozyurt/bin/mbirn_db.sql";

     try {
       isf = new InsertStatementFixer(filename, "dbutils.properties");
       isf.getCLOBColumnInfos();
       isf.parse();

     } catch (Exception ex) {
       ex.printStackTrace();
     } finally {
       if (isf != null)
         isf.shutdown();
     }

   }

}