package dbutils;

import java.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PrimaryKey.java,v 1.1.1.1 2005/10/25 18:32:59 bozyurt Exp $
 */

public class PrimaryKey {
  protected String name;
  protected String tableName;
  protected List colNames = new LinkedList();



  public PrimaryKey(String name, String tableName) {
    this.name = name;
    this.tableName = tableName;
  }

  public void addColumnName(String colName) {
    colNames.add(colName);
  }

  public List getColumnNames() { return colNames; }

  public String[] getColumnNamesAsArray() {
    String[] cnArr = new String[ colNames.size() ];
    return (String[]) colNames.toArray(cnArr);
  }

//---------------------- setters --------------
  public void setName(String newName) { this.name = newName; }
  public void setTableName(String newTableName) { this.tableName = newTableName; }
//---------------------- getters --------------
  public String getName() { return this.name; }
  public String getTableName() { return this.tableName; }

  public String toString() {
    StringBuffer buf = new StringBuffer(512);
    buf.append("PrimaryKey::[").append(name);
    buf.append(",tableName=").append(tableName);
    if ( !colNames.isEmpty() ) {
      buf.append("colNames=[");
    }
    for (Iterator iter = colNames.iterator(); iter.hasNext(); ) {
      String colName = (String)iter.next();
      buf.append(colName);
      if (iter.hasNext() ) buf.append(',');
    }
    if ( !colNames.isEmpty() )
      buf.append(']');
    buf.append(']');
    return buf.toString();


  }
}