package dbutils;


import java.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TableInfo.java,v 1.1.1.1 2005/10/25 18:32:59 bozyurt Exp $
 */
public class TableInfo {
  protected String name;
  protected List columns = new LinkedList();
  protected List constraints = new LinkedList();

  public TableInfo(String name) {
    this.name = name;
  }

  public void addColumnInfo(ColumnInfo ci) {
    columns.add(ci);
  }

  public List getColumns() { return columns; }

  public void addConstraint(ConstraintInfo ci) {
    constraints.add(ci);
  }

  public List getConstraints() { return constraints; }

  public String toString() {
    StringBuffer buf = new StringBuffer(512);
    buf.append("TableInfo::[").append(name);
    for (Iterator iter = columns.iterator(); iter.hasNext(); ) {
      ColumnInfo ci = (ColumnInfo)iter.next();
      buf.append("\n\t").append(ci.toString());
    }
    buf.append(']');
    return buf.toString();
  }

}