#!/usr/bin/python2

import os, string, sys, getpass, cx_Oracle

global db,cursor


def check_include(str):
  if str=="MODTIME" or str[-8:]=="UNIQUEID" or str=="STOREDASSESSMENTID" or str=="SEGMENTID" or str=="COMPONENTID" or str=="RATERID" or str=="STUDYID" or str=="EXPERIMENTID":
    return False
  else:
    return True;


def print_results(query):
  cursor.execute(query)
  columns=cursor.description
  for column in columns:
    if check_include(column[0])==True:
      print column[0],
  print
  while True:
    row=cursor.fetchone()
    if row==None:
      break
    for result in range(len(row)):
      column = columns[result][0]
      if check_include(column)==True:
        result_b=row[result]
        if result_b==None:
          print "NULL",
        else:
          print result_b,
    print
    

# Connect to a PostgreSQL database.
try:
  db = cx_Oracle.connect(sys.argv[1])
except:
  str=""
  print "Error connecting to the database: " + str
  sys.exit(1)
          
cursor = db.cursor()
          
print "********* nc_experiment **********"
query="select * from nc_experiment where name='Regression Test' order by name"
print_results(query)

print "******* nc_storedassessment ******"
query = "select * from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test') order by assessmentid, subjectid"
print_results(query)

print "****** nc_assessmentinteger ******"
query = "select * from nc_assessmentinteger where storedassessmentid in (select uniqueid from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by datavalue, scoreorder, assessmentid, subjectid"
print_results(query)

print "******* nc_assessmentfloat *******"
query = "select * from nc_assessmentfloat where storedassessmentid in (select uniqueid from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by datavalue, scoreorder, assessmentid, subjectid"
print_results(query)

print "****** nc_assessmentboolean ******"
query = "select * from nc_assessmentboolean where storedassessmentid in (select uniqueid from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by datavalue, scoreorder, assessmentid, subjectid"
print_results(query)

print "***** nc_assessmenttimestamp *****"
query = "select * from nc_assessmenttimestamp where storedassessmentid in (select uniqueid from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by datavalue, scoreorder, assessmentid, subjectid"
print_results(query)

print "****** nc_assessmentvarchar ******"
query = "select * from nc_assessmentvarchar where storedassessmentid in (select uniqueid from nc_storedassessment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by textvalue, scoreorder, assessmentid, subjectid"
print_results(query)

print "******** nc_subjexperiment *******"
query = "select * from nc_subjexperiment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test') order by subjectid, nc_experiment_uniqueid"
print_results(query)

print "********* nc_humansubject ********"
query = "select * from nc_humansubject where subjectid in (select subjectid from nc_subjexperiment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test')) order by subjectid"
print_results(query)

print "******** nc_expcomponent *********"
query = "select * from nc_expcomponent where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test') order by subjectid, time_stamp"
print_results(query)

print "******** nc_expstudy *********"
query = "select * from nc_expstudy where experimentid=(select uniqueid from nc_experiment where name='Regression Test') order by subjectid, time_stamp"
print_results(query)

print "********* nc_expsegment **********"
query = "select * from nc_expsegment where nc_experiment_uniqueid=(select uniqueid from nc_experiment where name='Regression Test') order by subjectid, time_stamp"
print_results(query)

print "**********************************"

db.close()
               
