-- retrieves the first assessment_id matching the as_name_in
-- returns -1 otherwise
create or replace FUNCTION get_assessment_id(as_name_in VARCHAR2) 
RETURN NUMBER
IS
  CURSOR  cur IS select ASSESSMENTID from nc_assessment
  where name = as_name_in;
  
  uid NUMBER;
  v_return number;
BEGIN
  OPEN cur;
  FETCH cur INTO uid;
  IF cur%FOUND THEN
    v_return := uid;
  else
    v_return := -1;
  END IF;
  CLOSE cur;
  return v_return;
EXCEPTION
   when others then
   if cur%isopen then
      close cur;
   end if;
   dbms_output.put_line('get_assessment_id failed.');
   raise;
END;
/

create or replace FUNCTION exists_securityClassification(
   SECURITYCLASSIFICATION_in VARCHAR2
) RETURN boolean
IS

  v_sc nc_securityClassification.securityClassification%type;
  v_return boolean;

  CURSOR c_cur IS SELECT securityClassification FROM nc_securityClassification
  WHERE upper(securityClassification) = UPPER( securityClassification_in );
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_sc;
  IF c_cur%FOUND THEN
    v_return := true;
  ELSE
    v_return := false;
  END IF;
  close c_cur;
  return v_return;
EXCEPTION
   when others then
   if C_cur%isopen then
      close C_cur;
   end if;
   dbms_output.put_line('exists_securityClassification failed.');
   raise;
END;
/

create or replace FUNCTION exists_assessment_score(
  assessment_id_in NUMBER,
  as_score_name_in VARCHAR2,
  as_score_type_in varchar2
) RETURN boolean
IS
   cursor c_cur is select uniqueId from nc_assessmentScore
   where upper(assessmentId) = upper(assessment_id_in)
   and upper(scoreName) = upper(as_score_name_in)
   and upper(scoreType) = upper(as_score_type_in);
   v_id number;
   v_return boolean;
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_id;
  IF c_cur%FOUND THEN
    v_return := true;
  ELSE
    v_return := false;
  END IF;
  close c_cur;
  return v_return;
EXCEPTION
   when others then
   if C_cur%isopen then
      close C_cur;
   end if;
   dbms_output.put_line('exists_assessment_score failed.');
   raise;
END;
/

--
-- returns a negative value in case of an error
-- returns assessmentID
--
create or replace FUNCTION add_assessment(as_name_in VARCHAR2,
   as_descr_in VARCHAR2,
   owner_id_in number,
   mod_user_id_in number,
   PREVIOUSASSESSMENTID_in number := null) RETURN NUMBER
IS
   as_id NUMBER;
BEGIN
   select uid_seq.nextval into as_id from dual;
   insert into nc_assessment(ASSESSMENTID,TABLEID,OWNER,MODTIME,
     MODUSER,NAME,DESCRIPTION,PREVIOUSASSESSMENTID)
   values(as_id, get_table_id('nc_assessment'), owner_id_in, SYSDATE, mod_user_id_in, as_name_in,
     as_descr_in, PREVIOUSASSESSMENTID_in);
   return as_id;
EXCEPTION
   when others then
   dbms_output.put_line('create add_assessment failed.');
   raise;
END;
/

create or replace procedure add_securityClassification(
   owner_id_in number,
   mod_user_id_in number,
   SECURITYCLASSIFICATION_in VARCHAR2,
   description_in VARCHAR2 := NULL
)
is
   
begin
   
   if not exists_securityClassification( securityClassification_in ) then
     INSERT INTO nc_securityClassification (securityClassification,
       UNIQUEID,TABLEID,OWNER,MODTIME, MODUSER,DESCRIPTION)
     VALUES(SECURITYCLASSIFICATION_in, uid_seq.nextval, get_table_id('nc_securityClassification'),
       owner_id_in, SYSDATE, mod_user_id_in, description_in );
   end if;
EXCEPTION
   when others then
   dbms_output.put_line('add_securityClassification failed.');
   raise;
end;
/


create or replace procedure add_assessment_score(
  assessment_id_in number,
  owner_id_in number,
  mod_user_id_in number,
  as_score_name_in VARCHAR2,
  as_score_seq_in number,
  as_score_type_in VARCHAR2,
  as_score_sec_class_in VARCHAR2,
  as_score_level_in number,
  as_score_default_val_in VARCHAR2 := NULL,
  as_parentid_in number := null,
  as_parentname_in varchar2 := null,
  as_score_nullable NUMBER := 1,
  as_score_ontology_in VARCHAR2 := 'N/A',
  as_score_concept_id_in varchar2,
  as_leading_text_in varchar2 := null,
  as_trailing_text_in varchar2 := null,
  MINANSWERS_in number := 1, 
  MAXANSWERS_in number := 1, 
  ISREQUIRED_in number := 1, 
  ISEXCLUDED_in number := 0, 
  ISNEW_in number := 1, 
  ISMODIFIED_in number := 0, 
  DESCRIPTION_in varchar2 := null
)
IS
   as_score_id NUMBER;
   sec_class VARCHAR2(128);
BEGIN
   
   -- see if the security class exists
   if not exists_securityclassification (as_score_sec_class_in ) then
      dbms_output.put_line('Cannot find securityclassification ' 
         || as_score_sec_class_in || '!');
      RETURN; 
   end if;
   
   select uid_seq.nextval into as_score_id from dual;
   insert into nc_assessmentscore( 
     ASSESSMENTID, SCORENAME, SCORESEQUENCE, SCORETYPE, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, 
     DEFAULTVALUE, NULLABLE, SCORELEVEL, PARENTASID, PARENTSCORE, ASSESSMENTONTOLOGY, 
     ASSESSMENTCONCEPT, SECURITYCLASSIFICATION, 
     MINANSWERS, MAXANSWERS, ISREQUIRED, ISEXCLUDED, ISNEW, ISMODIFIED, DESCRIPTION) 
   values(assessment_id_in, 
          as_score_name_in,
          as_score_seq_in, 
          as_score_type_in, 
          get_table_id('nc_assessment'), 
          as_score_id,
          owner_id_in,
          SYSDATE, 
          mod_user_id_in, 
          as_score_default_val_in,
          as_score_nullable,
          as_score_level_in,
          as_parentid_in,
          as_parentname_in, 
          as_score_ontology_in,  
          as_score_concept_id_in,
          as_score_sec_class_in,
          MINANSWERS_in, 
          MAXANSWERS_in, 
          ISREQUIRED_in, 
          ISEXCLUDED_in, 
          ISNEW_in, 
          ISMODIFIED_in, 
          DESCRIPTION_in);
  if not as_leading_text_in is null or not as_trailing_text_in is null then
    insert into nc_assessmentItem(ASSESSMENTID, SCORENAME, TABLEID, UNIQUEID, 
       OWNER, MODTIME, MODUSER, ITEMLEADINGTEXT, ITEMTRAILINGTEXT)
    values(assessment_id_in, as_score_name_in, get_table_id('nc_assessmentItem'), uid_seq.nextval,
       owner_id_in, sysdate, mod_user_id_in, as_leading_text_in, as_trailing_text_in);
  end if;
EXCEPTION
   when others then
   dbms_output.put_line('add_assessment_score failed.');
   raise;
END;
/


-- remove the assessment score it its owned by the modifiying user
create or replace PROCEDURE DELETE_ASSESSMENT_SCORE(
  assessment_name_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number,
  as_score_name_in VARCHAR2)
IS
   as_id NUMBER;
   v_count number;
BEGIN
   as_id := get_assessment_id(assessment_name_in);
   IF as_id = -1 THEN
      dbms_output.put_line('DELETE_ASSESSMENT_SCORE: Cannot find assessment ' || assessment_name_in || '!');
      return;
   END IF;
   
   if owner_id_in <> mod_user_id_in THEN
      dbms_output.put_line('DELETE_ASSESSMENT_SCORE: Both owner ' || owner_id_in || 
        ' and modifiying user '
        || mod_user_id_in || ' must be same for assessment score deletion!');
      return;
   END IF;
   

   delete from nc_assessmentInteger WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentBoolean WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentFloat WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentVarchar WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentTimeStamp WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentData WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentScoreCode WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in; 
   delete from nc_assessmentItem where scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
   delete from nc_assessmentscore WHERE scoreNAME = as_score_name_in
      AND ASSESSMENTID = as_id AND OWNER = owner_id_in;
EXCEPTION
   when others then
   dbms_output.put_line('create DELETE_ASSESSMENT_SCORE failed.');
   raise;
END;
/

create or replace FUNCTION add_stored_assessment(
  assessment_id_in NUMBER,
  owner_id_in number,
  mod_user_id_in number,
  component_id_in NUMBER,
  experiment_id_in NUMBER,
  segment_id_in number,
  subject_id_in VARCHAR2,
  time_stamp_in TIMESTAMP,
        INFORMANTID_in varchar2,       
        INFORMANTRELATION_in varchar2,
        ISVALIDATED_in number :=0,       
        STATUS_in varchar2 :='000',                
        RATORQUALITY_in varchar2 := 'Good',     
        ISTIMEINTERVAL_in number :=0, 
        TIMEINTERVAL_in number := null
)
RETURN NUMBER
IS
   store_as_id NUMBER;
BEGIN
   select uid_seq.nextval into store_as_id from dual;
--   dbms_output.put_line(store_as_id || ',' || get_table_id('nc_assessment') || ',' || owner_id_in || ',sysdate,' || mod_user_id_in || ',' || component_id_in || ',' || experiment_id_in || ',' || segment_id_in || ',' || subject_id_in || ',sysdate,' || informantid_in || ',' || informantrelation_in || ',' || isvalidated_in || ',' || status_in || ',' || ratorquality_in || ',' || istimeinterval_in || ',' || timeinterval_in);
   insert into nc_storedassessment(UNIQUEID,
        ASSESSMENTID, TABLEID,
        OWNER,
        MODTIME,
        MODUSER,
        COMPONENTID,
        NC_EXPERIMENT_UNIQUEID,
        segmentID,
        SUBJECTID,
        TIME_STAMP,
        INFORMANTID,       
        INFORMANTRELATION,
        ISVALIDATED,       
        STATUS,                
        RATORQUALITY,     
        ISTIMEINTERVAL, 
        TIMEINTERVAL)
   values(store_as_id,
          assessment_id_in,
          get_table_id('nc_storedassessment'),
          owner_id_in,
          SYSDATE,
          mod_user_id_in,
          component_id_in,
          experiment_id_in,
          segment_id_in,
          subject_id_in,
          time_stamp_in,
        INFORMANTID_in,       
        INFORMANTRELATION_in,
        ISVALIDATED_in,       
        STATUS_in,                
        RATORQUALITY_in,     
        ISTIMEINTERVAL_in, 
        TIMEINTERVAL_in);
   return store_as_id;
EXCEPTION
   when others then
   dbms_output.put_line('create add_stored_assessment failed.');
   raise;
end;
/

create or replace procedure add_assessment_code(
  assessment_id_in NUMBER,
  owner_id_in number,
  mod_user_id_in number,
  as_score_name_in VARCHAR2,
  as_score_code_in varchar2,
  as_score_code_value_in varchar2,
  as_score_code_type_in varchar2,
DESCRIPTION_in varchar2 := null,
ONTOLOGYSOURCE_in varchar2 := 'UNKNOWN',
CONCEPTID_in varchar2 := '9999')
IS
   store_as_id NUMBER;
BEGIN

   if exists_assessment_score(assessment_id_in, as_score_name_in, as_score_code_type_in) then
      INSERT INTO nc_assessmentscorecode (assessmentID, scorename, scorecode,
        scorecodelabel, TABLEID, UNIQUEID,
        OWNER, MODTIME, MODUSER, scorecodevalue, scorecodeTYPE,
        DESCRIPTION, ONTOLOGYSOURCE, CONCEPTID)
      VALUES(assessment_id_in, as_score_name_in, as_score_code_in, as_score_code_in,
        get_table_id('nc_assessmentscorecode'),
        uid_seq.nextval, owner_id_in, SYSDATE, mod_user_id_in, as_score_code_value_in,
        as_score_code_type_in, DESCRIPTION_in, ONTOLOGYSOURCE_in, CONCEPTID_in);
   else
      Raise_application_error(-20013, 'add_assessment_code: ' || as_score_name_in || ', ' ||
        as_score_code_type_in || 'is not found!');
   end if;
EXCEPTION
   when others then
   dbms_output.put_line('add_assessment_code failed.');
   raise;
END;
/

create or replace FUNCTION store_assessment_value(
  assessment_id_in NUMBER,
  store_as_id_in number,
  owner_id_in number,
  mod_user_id_in number,
  as_score_name_in VARCHAR2,
  as_score_type_in VARCHAR2,
  as_score_order_in number,
  data_val_num_in NUMBER := NULL,
  data_val_str_in varchar2 := NULL,
  data_val_norm_num_in number := NULL,
  data_val_norm_str_in varchar2 := NULL,
  comments_in CLOB := NULL,
  timestamp_format_in varchar2 := 'MM-DD-YYYY HH24:MI:SSxFF',
  missing_data_code_in varchar2 := NULL,
  ISVALIDATED_in NUMBER := NULL,
  ISRANKED_in NUMBER := NULL,
  SUBJECTID_in VARCHAR2 := NULL,
  ENTRYID_in NUMBER := NULL,
  KEYERID_in NUMBER := NULL,
  RATERID_in NUMBER := NULL)
RETURN NUMBER
IS
   ast VARCHAR2(64);
   as_data_id NUMBER;
   classification NUMBER;
   cursor c_cur is SELECT uniqueid FROM nc_dataclassification WHERE name=missing_data_code_in;
BEGIN
   ast :=  LOWER(as_score_type_in);
   IF  ast <> 'integer' AND ast <> 'float' AND ast <> 'boolean'
     AND ast <> 'varchar' AND ast <> 'timestamp' THEN
     Raise_application_error(-20010,'store_assessment_value: Not a supported type ' || as_score_type_in || '!');
   END IF;

   OPEN c_cur;
   FETCH c_cur INTO classification;
   -- IF c_cur%FOUND THEN
   --   v_return := true;
   -- ELSE
   -- v_return := false;

   --SELECT uniqueid into classification FROM nc_dataclassification WHERE name=missing_data_code_in;

   select uid_seq.nextval into as_data_id from dual;
   if ast = 'integer' then
      INSERT INTO nc_assessmentInteger (TABLEID, NC_ASSESSMENTDATA_UNIQUEID, scoreOrder,
        OWNER, MODTIME, MODUSER, TEXTVALUE, TEXTNORMVALUE,
        COMMENTS, DATAVALUE, DATANORMVALUE,
        STOREDASSESSMENTID, ASSESSMENTID, scoreNAME, scoreTYPE,
	ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID, classification)
      VALUES(get_table_id('nc_assessmentInteger'), as_data_id, as_score_order_in, owner_id_in, SYSDATE, mod_user_id_in,
        data_val_str_in, data_val_norm_str_in,
        comments_in, data_val_num_in, data_val_norm_num_in,
        store_as_id_in, assessment_id_in,as_score_name_in, as_score_type_in,
        ISVALIDATED_in,ISRANKED_in,SUBJECTID_in,ENTRYID_in,KEYERID_in,RATERID_in,
	classification);
   elsif ast = 'float' then
      INSERT INTO nc_assessmentFloat (TABLEID, NC_ASSESSMENTDATA_UNIQUEID, scoreOrder,
        OWNER, MODTIME, MODUSER, TEXTVALUE, TEXTNORMVALUE,
        COMMENTS, DATAVALUE, DATANORMVALUE,
        STOREDASSESSMENTID, ASSESSMENTID, scoreNAME, scoreTYPE,
	ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID, classification)
      VALUES(get_table_id('nc_assessmentFloat'), as_data_id, as_score_order_in, owner_id_in, SYSDATE, mod_user_id_in,
        data_val_str_in, data_val_norm_str_in,
        comments_in, data_val_num_in, data_val_norm_num_in,
        store_as_id_in, assessment_id_in,as_score_name_in, as_score_type_in,
        ISVALIDATED_in,ISRANKED_in,SUBJECTID_in,ENTRYID_in,KEYERID_in,RATERID_in,
        classification);
   elsif ast = 'timestamp' then
      INSERT INTO nc_assessmentTimestamp(TABLEID, NC_ASSESSMENTDATA_UNIQUEID, scoreOrder,
        OWNER, MODTIME, MODUSER, TEXTVALUE, TEXTNORMVALUE,
        COMMENTS, DATAVALUE, DATANORMVALUE,
        STOREDASSESSMENTID, ASSESSMENTID, scoreNAME, scoreTYPE,          
	ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID, classification)
      VALUES(get_table_id('nc_assessmentTimestamp'), as_data_id, as_score_order_in, owner_id_in, SYSDATE, mod_user_id_in,
        data_val_str_in, data_val_norm_str_in,
        comments_in, to_timestamp(data_val_str_in, timestamp_format_in),
        to_timestamp(data_val_norm_str_in, timestamp_format_in),
        store_as_id_in, assessment_id_in,as_score_name_in, as_score_type_in,
        ISVALIDATED_in,ISRANKED_in,SUBJECTID_in,ENTRYID_in,KEYERID_in,RATERID_in,
        classification);
   elsif ast = 'boolean' then
      INSERT INTO nc_assessmentBoolean (TABLEID, NC_ASSESSMENTDATA_UNIQUEID, scoreOrder,
        OWNER, MODTIME, MODUSER, TEXTVALUE, TEXTNORMVALUE,
        COMMENTS, DATAVALUE, DATANORMVALUE,
        STOREDASSESSMENTID, ASSESSMENTID, scoreNAME, scoreTYPE,          
	ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID, classification)
      VALUES(get_table_id('nc_assessmentBoolean'), as_data_id, as_score_order_in, owner_id_in, SYSDATE, mod_user_id_in,
        to_char(data_val_num_in), to_char(data_val_norm_num_in),
        comments_in, data_val_num_in, data_val_norm_num_in,
        store_as_id_in, assessment_id_in,as_score_name_in, as_score_type_in,
        ISVALIDATED_in,ISRANKED_in,SUBJECTID_in,ENTRYID_in,KEYERID_in,RATERID_in,
        classification);
   elsif ast = 'varchar' then
      INSERT INTO nc_assessmentVarchar (TABLEID, NC_ASSESSMENTDATA_UNIQUEID, scoreOrder,
        OWNER, MODTIME, MODUSER, TEXTVALUE, TEXTNORMVALUE,
        COMMENTS, DATAVALUE, DATANORMVALUE,
        STOREDASSESSMENTID, ASSESSMENTID, scoreNAME, scoreTYPE,          
	ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID, classification)
      VALUES(get_table_id('nc_assessmentVarchar'), as_data_id, as_score_order_in, owner_id_in, SYSDATE, mod_user_id_in,
        data_val_str_in, data_val_norm_str_in,
        comments_in, data_val_str_in, data_val_norm_str_in,
        store_as_id_in, assessment_id_in,as_score_name_in, as_score_type_in,
        ISVALIDATED_in,ISRANKED_in,SUBJECTID_in,ENTRYID_in,KEYERID_in,RATERID_in,
        classification);
   end if;
   return as_data_id;
EXCEPTION
   when others then
   dbms_output.put_line('store_assessment_value failed.');
   raise;
END;
/
