--return visit_id if exists or -1 otherwise
create or replace FUNCTION get_visit_id(
   experiment_ID_in number,  subject_id_in varchar2
) return number
IS
v_uid NUMBER;
BEGIN
  select max(COMPONENTID) into v_uid from nc_expcomponent
  where NC_EXPERIMENT_UNIQUEID = experiment_ID_in and SUBJECTID = subject_id_in;
  if v_uid is null then
     v_uid := -1;
  end if;
  return v_uid;
EXCEPTION
  when others then
    return -1;
END; 
/

--return segment_id if exists or -1 otherwise
create or replace FUNCTION get_study_id(
   visit_id_in number, experiment_ID_in number,  subject_id_in varchar2
) return number
IS
v_uid NUMBER;
BEGIN
  select max(STUDYID) into v_uid from nc_expStudy
     where COMPONENTID = visit_id_in and EXPERIMENTID = experiment_ID_in
     and SUBJECTID = subject_id_in;
  if v_uid is null then
     v_uid := -1;
  end if;
  return v_uid;
EXCEPTION
  when others then
    return -1;
END;
/

--return segment_id if exists or -1 otherwise
create or replace FUNCTION get_segment_id(
   visit_id_in number, experiment_ID_in number,  subject_id_in varchar2
) return number
IS
v_uid NUMBER;
BEGIN
  select max(SEGMENTID) into v_uid from nc_expsegment
     where COMPONENTID = visit_id_in and NC_EXPERIMENT_UNIQUEID = experiment_ID_in
     and SUBJECTID = subject_id_in;
  if v_uid is null then
     v_uid := -1;
  end if;
  return v_uid;
EXCEPTION
  when others then
    return -1;
END;
/

--return experiment_id if exists or -1 otherwise
create or replace FUNCTION get_experiment_id(exp_name_in varchar2) return number
IS
cursor c_cur IS SELECT UNIQUEID from nc_experiment where name = exp_name_in;
v_uid NUMBER := -1;
v_return NUMBER := -1;
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_uid;
  if c_cur%found then
     v_return := v_uid;
  end if;
  CLOSE c_cur;
  return v_return;
END;
/

--return research_group_type_id if exists or -1 otherwise
create or replace FUNCTION get_research_group_type_id(name_in varchar2) return number
IS
cursor c_cur IS SELECT UNIQUEID FROM nc_researchGroupType WHERE name = name_in;
v_uid NUMBER := -1;
v_return NUMBER := -1;
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_uid;
  if c_cur%found then
     v_return := v_uid;
  end if;

  CLOSE c_cur;
  return v_return;
END;
/

--return research_group_id if exists or -1 otherwise
create or replace FUNCTION get_research_group_id(name_in VARCHAR2) RETURN NUMBER
IS
cursor c_cur IS SELECT UNIQUEID FROM nc_researchGroup WHERE name = name_in;
v_uid NUMBER := -1;
v_return NUMBER := -1;
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_uid;
  if c_cur%found then
     v_return := v_uid;
  end if;

  CLOSE c_cur;
  return v_return;
END;
/

--return species_id if exists or -1 otherwise
create or replace FUNCTION get_species_id(strain_in VARCHAR2) RETURN NUMBER
IS
cursor c_cur IS SELECT UNIQUEID FROM nc_animalspecies WHERE strain = strain_in;
v_uid NUMBER := -1;
v_return NUMBER := -1;
BEGIN
  OPEN c_cur;
  FETCH c_cur INTO v_uid;
  if c_cur%found then
     v_return := v_uid;
  end if;

  CLOSE c_cur;
  return v_return;
END;
/

create or replace function exists_exp_segment(
  COMPONENT_ID_in number,
  experiment_id_in number,
  subject_id_in VARCHAR2,
  protocol_version_in number,
  protocol_id_in VARCHAR2,
  time_stamp_in TIMESTAMP
) return boolean
IS

  cursor c_cur is select UNIQUEID from nc_expSegment
    where upper(protocolID) = upper(protocol_id_in)
    and PROTOCOLVERSION = protocol_version_in
    and COMPONENTID = COMPONENT_ID_in
    and NC_EXPERIMENT_UNIQUEID = experiment_id_in
    and SUBJECTID = subject_id_in
    and time_stamp = time_stamp_in;
  v_junk number;
  v_id number;
  v_return boolean;
BEGIN
   OPEN c_cur;
   fetch c_cur into v_id;
   if c_cur%FOUND then
      v_return := true;
   else
      v_return := false;
   end if;
   CLOSE c_cur;
   return v_return;
END;
/

create or replace function exists_exp_study(
  COMPONENT_ID_in number,
  experiment_id_in number,
  subject_id_in VARCHAR2,
  time_stamp_in TIMESTAMP
) return boolean
IS
  cursor c_cur is select UNIQUEID from nc_expStudy
    where COMPONENTID = COMPONENT_ID_in
    and EXPERIMENTID = experiment_id_in
    and SUBJECTID = subject_id_in
    and time_stamp = time_stamp_in;
  v_junk number;
  v_id number;
  v_return boolean;
BEGIN
   OPEN c_cur;
   fetch c_cur into v_id;
   if c_cur%FOUND then
      v_return := true;
   else
      v_return := false;
   end if;
   CLOSE c_cur;
   return v_return;
END;
/

create or replace function exists_protocol(
  protocol_version_in number,
  protocol_id_in VARCHAR2
) return boolean
IS
  cursor c_cur is select UNIQUEID from nc_protocol
    where upper(protocolID) = upper(protocol_id_in)
    and protocolVersion = protocol_version_in ;
  v_id number;
  v_return boolean;
BEGIN
   OPEN c_cur;
   fetch c_cur into v_id;
   if c_cur%FOUND then
      v_return := true;
   else
      v_return := false;
   end if;
   CLOSE c_cur;
   return v_return;
END;
/

create or replace function exists_visit_type(visit_type_in VARCHAR2
) return boolean
IS
  cursor c_cur is select UNIQUEID from nc_visitType
    where upper(VISITTYPE) = upper(visit_type_in);
  v_id number;
  v_return boolean;
BEGIN
   OPEN c_cur;
   fetch c_cur into v_id;
   if c_cur%FOUND then
      v_return := true;
   else
      v_return := false;
   end if;
   CLOSE c_cur;
   return v_return;
END;
/


create or replace procedure add_research_group(
       rg_name_in varchar2,
       rg_descr_in varchar2,
       rg_type_in varchar2,
       exp_name_in varchar2,
       owner_id_in number,
       mod_user_id_in number)
is
	rg_type_id NUMBER;
	exp_id NUMBER;
begin
	rg_type_id := get_research_group_type_id(rg_type_in);
	exp_id := get_experiment_id(exp_name_in);
	insert into nc_researchgroup ( UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER,
	        NAME, DESCRIPTION, NC_RESEARCHGROUPTYPE_UNIQUEID, NC_EXPERIMENT_UNIQUEID)
		values( uid_seq.nextval, get_table_id('nc_researchgroup'), owner_id_in, SYSDATE, mod_user_id_in,
		       rg_name_in, rg_descr_in, rg_type_id, exp_id);
end;
/

--add nc_person
--add nc_experiment
create or replace PROCEDURE add_experiment(owner_id_in number,
    mod_user_id_in number,
    name_in VARCHAR2,
    descr_in VARCHAR2,
    contact_first_name_in VARCHAR2,
    contact_last_name_in VARCHAR2,
    contact_email_in varchar2,
    baseURI_in varchar2 := Null,
    isregression_in number := NULL)
IS
  contact_person_id NUMBER;

BEGIN
   contact_person_id := get_person_id(contact_first_name_in, contact_last_name_in, contact_email_in);
   if contact_person_id < 0 then
      select uid_seq.nextval into contact_person_id from dual;
      insert into nc_person(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, FIRST_NAME, LAST_NAME, EMAIL)
      values(contact_person_id, get_table_id('nc_person'), owner_id_in, SYSDATE, mod_user_id_in,
	     contact_first_name_in, contact_last_name_in, contact_email_in);
   end if;
   INSERT INTO nc_experiment ( UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,
        NAME,DESCRIPTION,CONTACTPERSON,BASEURI,ISREGRESSIONDATA)
   VALUES(uid_seq.nextval, get_table_id('nc_experiment'), owner_id_in, SYSDATE, mod_user_id_in,
      name_in,  descr_in, contact_person_id, baseURI_in, isregression_in);
END;
/



--add subject to nc_humanSobject if not in db, nc_subjexperiment, nc_expcomponent,
--get exp_id, researchGroupID,
create or replace FUNCTION add_exp_component(birn_id_in VARCHAR2,
  exp_name_in VARCHAR2,
  research_group_name_in VARCHAR2,
  visit_date_in TIMESTAMP,
  visit_descr_in CLOB,
  visit_type_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number,
  subj_NAME_in VARCHAR2 := null,
  BIRTHDATE_in date := null,
  LOCALID_in VARCHAR2 := null,
  comp_NAME_in VARCHAR2 := null,
  TIMEINTERVAL_in number := null,
  ISTIMEINTERVAL_in number :=0
) return number
IS
  subject_id VARCHAR2(128);
  species_id NUMBER;
  experiment_id NUMBER;
  visit_id number;
  research_subject_id NUMBER;
  CURSOR hs_cur IS SELECT subjectID from nc_humanSubject where subjectID = birn_id_in;
BEGIN
  OPEN hs_cur;
  FETCH hs_cur INTO subject_id;
  IF hs_cur%NOTFOUND THEN
     species_id :=  get_species_id('human');
     INSERT INTO  nc_humanSubject ( SUBJECTID,TABLEID,UNIQUEID,
        OWNER,MODTIME,MODUSER,EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID,
        NAME, BIRTHDATE, LOCALID)
     VALUES(birn_id_in,  get_table_id('nc_humanSubject'), uid_seq.nextval,
     owner_id_in, SYSDATE, mod_user_id_in, 'humanSubject', species_id,
        subj_NAME_in, BIRTHDATE_in, LOCALID_in);
  END IF;
  CLOSE hs_cur;

  experiment_id := get_experiment_id(exp_name_in);
  --dbms_output.put_line(experiment_id);
  IF experiment_id > 0 THEN

     research_subject_id := get_research_group_id(research_group_name_in);
     --dbms_output.put_line(research_subject_id);
     INSERT INTO nc_subjexperiment ( UNIQUEID, TABLEID,  OWNER,  MODTIME,MODUSER,
               NC_EXPERIMENT_UNIQUEID,SUBJECTID,NC_RESEARCHGROUP_UNIQUEID)
      VALUES(uid_seq.nextval, get_table_id('nc_subjexperiment'), owner_id_in, SYSDATE, mod_user_id_in, experiment_id,
           birn_id_in,research_subject_id );
     select count(*) + 1 into visit_id from nc_expcomponent
     where NC_EXPERIMENT_UNIQUEID = experiment_id and SUBJECTID = birn_id_in;
     INSERT INTO nc_expcomponent (COMPONENTID, NC_EXPERIMENT_UNIQUEID,SUBJECTID,
        UNIQUEID,TABLEID,OWNER,MODTIME, MODUSER,TIME_STAMP, DESCRIPTION,
        VISITTYPE, NAME, TIMEINTERVAL, ISTIMEINTERVAL)
     VALUES( visit_id, experiment_id, birn_id_in, uid_seq.nextval, get_table_id('nc_expcomponent'), owner_id_in,
            SYSDATE,
            mod_user_id_in,
            visit_date_in,
            visit_descr_in,
            visit_type_in, 
	    comp_NAME_in, TIMEINTERVAL_in, ISTIMEINTERVAL_in);
  ELSE
     dbms_output.put_line( exp_name_in || ' is not found!');
  END IF;
  return visit_id;
EXCEPTION
  WHEN OTHERS
  THEN
    dbms_output.put_line( 'sqlcode: ' || sqlcode);
    dbms_output.put_line( 'sqlerrM: ' || sqlerrm);
    IF hs_cur%ISOPEN THEN
      CLOSE hs_cur;
    END IF;
    RAISE;
END;
/

create or replace PROCEDURE drop_exp_component(birn_id_in VARCHAR2,
  exp_name_in VARCHAR2,
  research_group_name_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number
)
IS
  subject_id VARCHAR2(128);
  exp_id NUMBER;
  research_subject_id NUMBER;
  CURSOR hs_cur IS SELECT subjectID from nc_humanSubject where subjectID = birn_id_in;
  CURSOR exp_cur IS SELECT  UNIQUEID FROM nc_experiment WHERE name = exp_name_in;
BEGIN
   OPEN hs_cur;
   fetch hs_cur into subject_id;
   if hs_cur%FOUND then
      OPEN exp_cur;
      fetch exp_cur into exp_id;
      if exp_cur%FOUND then
	 research_subject_id := get_research_group_id(research_group_name_in);
	 delete from nc_subjexperiment where NC_EXPERIMENT_UNIQUEID = exp_id
	    and SUBJECTID = subject_id and NC_RESEARCHGROUP_UNIQUEID = research_subject_id;
	 --delete from nc_rawData where segment...
         delete from nc_expSegment where NC_EXPERIMENT_UNIQUEID = exp_id
	    and SUBJECTID = subject_id and COMPONENTID in 
            (select COMPONENTID from nc_expcomponent where  NC_EXPERIMENT_UNIQUEID = exp_id
	   and SUBJECTID = subject_id);
         delete from nc_expStudy where EXPERIMENTID = exp_id
	    and SUBJECTID = subject_id and COMPONENTID in 
            (select COMPONENTID from nc_expcomponent where  NC_EXPERIMENT_UNIQUEID = exp_id
	   and SUBJECTID = subject_id);
	 delete from nc_expcomponent where  NC_EXPERIMENT_UNIQUEID = exp_id
	   and SUBJECTID = subject_id;

      end if;
      close exp_cur;
      --delete from nc_humanSubject where SUBJECTID = subject_id;
   end if;
   CLOSE hs_cur;
END;
/


create or replace procedure add_visit_type(
  visit_type_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number, 
  description_in VARCHAR2 := null
)
is
begin
   if not exists_visit_type(visit_type_in) then
      insert into nc_visitType(VISITTYPE, UNIQUEID, TABLEID, OWNER, 
        MODTIME, MODUSER, DESCRIPTION)
      values(visit_type_in, uid_seq.nextval, get_table_id('nc_visitType'), owner_id_in, 
        sysdate, mod_user_id_in, description_in);
   end if;
END;
/

create or replace procedure add_protocol(
  protocol_version_in number,
  protocol_id_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number,
  name_in varchar2 := null, 
  description_in VARCHAR2 := null
)
is
begin
   if not exists_protocol(protocol_version_in, protocol_id_in) then
      insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, 
        MODTIME, MODUSER, name, DESCRIPTION)
      values(protocol_version_in, protocol_id_in, uid_seq.nextval, get_table_id('nc_protocol'), owner_id_in, 
        sysdate, mod_user_id_in, name_in, description_in);
   end if;
END;
/


create or replace function add_exp_segment(
  COMPONENT_ID_in number,
  experiment_id_in number,
  subject_id_in varchar2,
  protocol_version_in number,
  protocol_id_in VARCHAR2,
  owner_id_in number,
  mod_user_id_in number,
  time_stamp_in TIMESTAMP, 
  description_in CLOB := null,
  STUDYID_in number := null, 
  NAME_in VARCHAR2 := null,
  ISTIMEINTERVAL_in number :=0, 
  TIMEINTERVAL_in number := null, 
  ISBAD_in number := 0
) return number
is
  v_segment_id number;
begin
   select uid_seq.nextval into v_segment_id from dual;
   if not exists_exp_segment(COMPONENT_ID_in, experiment_id_in, subject_id_in, 
     protocol_version_in, protocol_id_in, time_stamp_in) then
      insert into nc_expsegment(SEGMENTID, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID,
        UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP,
        DESCRIPTION, PROTOCOLVERSION, PROTOCOLID,
	STUDYID, NAME, ISTIMEINTERVAL, TIMEINTERVAL, ISBAD)
      values(v_segment_id, COMPONENT_ID_in, experiment_id_in, subject_id_in,
        uid_seq.nextval, get_table_id('nc_expsegment'), owner_id_in, sysdate, mod_user_id_in, time_stamp_in, 
        description_in, protocol_version_in, protocol_id_in,
	STUDYID_in, NAME_in, ISTIMEINTERVAL_in, TIMEINTERVAL_in, ISBAD_in);
   else
     select SEGMENTID into v_segment_id from nc_expsegment
     where COMPONENTID = COMPONENT_ID_in and NC_EXPERIMENT_UNIQUEID = experiment_id_in
     and SUBJECTID = subject_id_in and PROTOCOLVERSION = protocol_version_in 
     and PROTOCOLID = protocol_id_in;
   end if;
   return v_segment_id;
END;
/

create or replace function add_exp_study(
  COMPONENT_ID_in number,
  experiment_id_in number,
  subject_id_in varchar2,
  owner_id_in number,
  mod_user_id_in number,
  time_stamp_in TIMESTAMP, 
  name_in VARCHAR := null,
  description_in CLOB := null,
  STUDYID_in number := null, 
  ISTIMEINTERVAL_in number :=0, 
  TIMEINTERVAL_in number := null
) return number
is
  v_study_id number;
begin
   select uid_seq.nextval into v_study_id from dual;
   if not exists_exp_study(COMPONENT_ID_in, experiment_id_in, subject_id_in, 
     time_stamp_in) then
      insert into nc_expstudy(STUDYID, COMPONENTID, EXPERIMENTID, SUBJECTID,
        UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP,
        NAME, DESCRIPTION, ISTIMEINTERVAL, TIMEINTERVAL)
      values(v_study_id, COMPONENT_ID_in, experiment_id_in, subject_id_in,
        uid_seq.nextval, get_table_id('nc_expstudy'), owner_id_in, sysdate,
        mod_user_id_in, time_stamp_in, name_in, description_in,
        ISTIMEINTERVAL_in, TIMEINTERVAL_in);
   else
     select STUDYID into v_study_id from nc_expstudy
     where COMPONENTID = COMPONENT_ID_in and EXPERIMENTID = experiment_id_in
     and SUBJECTID = subject_id_in;
   end if;
   return v_study_id;
END;
/
