
--Add acttask
create or replace procedure acttask(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('acttask', 'acttask', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'AC22', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK PORTEUS - TIME (SECONDS)');

add_assessment_score(v_id1, owner_id, owner_id, 'ACVER', 8, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AC23', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - TEST ITEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'ACFRM', 7, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK FORM NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ACFUPER', 2, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK FOLLOW-UP PERIOD (months)');

add_assessment_score(v_id1, owner_id, owner_id, 'AC20', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK PORTEUS - COMPLETED SERIES?');

add_assessment_score(v_id1, owner_id, owner_id, 'ACREL', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CHRONO RELIABILITY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AC21', 29, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK PORTEUS - LEVEL ACHIEVED');

add_assessment_score(v_id1, owner_id, owner_id, 'AC26', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - INCORRECT RESPONSES');

add_assessment_score(v_id1, owner_id, owner_id, 'ACID', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK SUBJECT ID');

add_assessment_score(v_id1, owner_id, owner_id, 'AC24', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - TARGET OCCURRENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC12', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC17', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # NON PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'AC16', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'AC15', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'AC14', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC13', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK TOWER OF LONDON SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'ACASS', 5, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CHRONO ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AC11', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC10', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC28', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - SCORE (percent)');

add_assessment_score(v_id1, owner_id, owner_id, 'AC25', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - CORRECT RESPONSES');

add_assessment_score(v_id1, owner_id, owner_id, 'AC18', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # PERSEV ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'AC19', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK WISCONSIN - # CATEGORIES');

add_assessment_score(v_id1, owner_id, owner_id, 'ACACTASK', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK ACTIVATION TASK');

add_assessment_score(v_id1, owner_id, owner_id, 'AC3', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - % COMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC2', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - # COMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC1', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - # OMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC7', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC6', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - % COMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC5', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - # COMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC4', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 2 - # OMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'AC27', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT 1990 - TIME (mlsec)');

add_assessment_score(v_id1, owner_id, owner_id, 'AC9', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AC8', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK CPT TRIAL 1 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'ACPROC', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ACT TASK PROCEDURE');

commit;
END;
/
