
--Add aims
create or replace procedure aims(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('aims', 'aims', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AI100', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS LATERALITY OF ABNORMAL MOVEMENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'AI100', 0, 'N/A', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI100', 1, 'L>R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI100', 2, 'R>L', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI100', 3, 'L=R', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'AI9', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"AIMS UPPER (ARMS,WAIST,HANDS,FINGERS)"');
add_assessment_code(v_id1, owner_id, owner_id, 'AI9', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI9', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI9', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI9', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI9', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS MEDICATION STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AI8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS TONGUE');
add_assessment_code(v_id1, owner_id, owner_id, 'AI8', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI8', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI8', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI8', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI8', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI5', 18, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS MUSCLES OF FACIAL EXPRESSION');
add_assessment_code(v_id1, owner_id, owner_id, 'AI5', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI5', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI5', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI5', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI5', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI15', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS CURRENT PROBS WITH TEETH/DENTURES');

add_assessment_score(v_id1, owner_id, owner_id, 'AI7', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS JAW');
add_assessment_code(v_id1, owner_id, owner_id, 'AI7', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI7', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI7', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI7', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI7', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI6', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS LIPS AND PERIORAL AREA');
add_assessment_code(v_id1, owner_id, owner_id, 'AI6', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI6', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI6', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI6', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI6', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS PATIENT STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'AI11', 24, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"AIMS NECK,SHOULDERS,HIPS"');
add_assessment_code(v_id1, owner_id, owner_id, 'AI11', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI11', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI11', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI11', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI11', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI10', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"AIMS LOWER (LEGS,KNEES,ANKLES,TOES)"');
add_assessment_code(v_id1, owner_id, owner_id, 'AI10', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI10', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI10', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI10', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI10', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI13', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS INCAP DUE TO ABNORMAL MOVEMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'AI12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS SEVERITY OF ABNORMAL MOVEMENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'AI12', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI12', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI12', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI12', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI12', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI14', 28, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS PT AWARE OF ABNORMAL MOVEMENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'AI14', 0, 'No Awareness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI14', 1, 'Aware, No Distress', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI14', 2, 'Aware, Mild Distress', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI14', 3, 'Aware, Moderate Distress', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'AI14', 4, 'Aware, Severe Distress', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AI16', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AIMS DOES PT WEAR DENTURES?');

commit;
END;
/
