
--Add barnes
create or replace procedure barnes(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('barnes', 'barnes', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'BA5', 18, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES OBJECTIVE');
add_assessment_code(v_id1, owner_id, owner_id, 'BA5', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA5', 1, 'Presence of characteristic restless movements', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA5', 2, 'Observed phenomena for at least half the observation period', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA5', 3, 'Patient constantly engaged in resless movements', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"BARNES MEDICATION STATUS(0=NO MED,1=MED)"');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BA7', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES SUBJECTIVE-DISTRESS RESTLESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'BA7', 0, 'No distress', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA7', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA7', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA7', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BA6', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES SUBJECTIVE-AWARENESS RESTLESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'BA6', 0, 'Absence of inner restlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA6', 1, 'Non-specific sense of inner restlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA6', 2, 'Patient is aware of an inability to keep legs still', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA6', 3, 'Awareness of an intense compulsion to move most of the time', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'BA8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES GLOBAL CLINICAL ASSESS AKATHISIA');
add_assessment_code(v_id1, owner_id, owner_id, 'BA8', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA8', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA8', 2, 'Mild akathisia', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA8', 3, 'Moderate akathisia', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'BA8', 4, 'Severe akathisia', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES DRUG STATUS AT INTAKE');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARNES ASSESSMENT NUMBER');

commit;
END;
/
