set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9113816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '0332230',
      3.074856,
      0.235064,
      NULL,
      2,
      '2330',
      2,
      NULL,
      NULL,
      NULL,
      ' 5-10-1983',
      14.215615,
      NULL,
      NULL,
      1.754102,
      NULL,
      ' 0-15-1992',
      16.717802,
      0.676078,
      65,
      46.659675,
      1.543453,
      ' 2- 4-1996',
      ' 6- 7-2003',
      '10-16-1982',
      NULL,
      0,
      2.082838,
      1,
      1.093848,
      0.489849,
      3,
      1,
      0,
      43.807204,
      NULL,
      2,
      3,
      24,
      24.785054,
      6.441933,
      23.419820,
      0.437760,
      1,
      NULL,
      3.966970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.624125,
      NULL,
      0,
      0,
      0,
      3,
      9,
      2.876343,
      NULL,
      6,
      NULL,
      1,
      0,
      2.114190,
      4,
      1.574691,
      5,
      NULL,
      5.653056,
      0.712685,
      NULL,
      NULL,
      0.429654,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963841,
      NULL,
      1.905734,
      0,
      3.298019,
      1,
      3.110776,
      1.567816,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.156685,
      3.864654,
      3,
      1,
      NULL,
      1,
      5.841945,
      NULL,
      0.223997,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.682118,
      NULL,
      NULL,
      1.356333,
      8.636517,
      NULL,
      0,
      8,
      2.490000,
      4,
      0,
      0.786299,
      3,
      0,
      1.067336,
      NULL,
      NULL,
      1.970610,
      1.792990,
      0.207927,
      1,
      2,
      0,
      0,
      4,
      0.059928,
      0,
      7,
      0.424463,
      2,
      NULL,
      4,
      3.740923,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.518359,
      5,
      NULL,
      8,
      11,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      1.511195,
      1.871057,
      ' 0-25-1980',
      NULL,
      ' 1- 1-1983',
      111,
      3,
      0,
      NULL,
      2,
      1.720460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.631435,
      1.801551,
      NULL,
      0.334521,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.171843,
      2.570264,
      1.760685,
      0.700691,
      0.145602,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.511580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0.568982,
      1,
      0,
      3.527859,
      22.053249,
      1.116316,
      1,
      43,
      2.059540,
      142,
      3,
      1,
      0.982132,
      1.839880,
      3.552844,
      2,
      2.548180,
      0,
      1.928828,
      3.101305,
      0.802649,
      0,
      2.443843,
      3,
      NULL,
      1,
      3.996235,
      0,
      0.521208,
      0,
      1.853212,
      0.294663,
      1.205681,
      1.065366,
      0.727789,
      1,
      0.014913,
      0,
      0.491245,
      1.572727,
      3,
      1.442379,
      3,
      8.290711,
      4,
      0,
      NULL,
      2,
      NULL,
      0,
      7.160361,
      2,
      2.333731,
      NULL,
      44,
      1,
      1.494661,
      NULL,
      10,
      38,
      31,
      NULL,
      1.965219,
      NULL,
      '30403',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '22241',
      '',
      NULL,
      NULL,
      17.931158,
      158,
      0,
      2.610999,
      22,
      10.305302,
      NULL,
      3,
      0.225543,
      1.264500,
      2.044991,
      1.633113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607220,
      0.626257,
      3.443428,
      0,
      0.214630,
      0.045387,
      0,
      NULL,
      NULL,
      2,
      0,
      2.440533,
      2,
      2,
      3.016259,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0.375920,
      NULL,
      NULL,
      NULL,
      6,
      11.242834,
      1.168494,
      1,
      0.729624,
      NULL,
      NULL,
      NULL,
      0.263775,
      NULL,
      NULL,
      NULL,
      3.437388,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.332655,
      NULL,
      3.482949,
      0.546063,
      1,
      0,
      1.786745,
      NULL,
      1.184859,
      1.936482,
      NULL,
      0.566605,
      0,
      3.556834,
      NULL,
      1.576308,
      NULL,
      NULL,
      1.904775,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.676843,
      11,
      NULL,
      1.240912,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.178617,
      NULL,
      NULL,
      3.830537,
      3,
      0.870265,
      2,
      1,
      0.104749,
      1.108083,
      NULL,
      NULL,
      4.946063,
      4.973047,
      NULL,
      1.522675,
      NULL,
      2.224412,
      2.575416,
      1,
      0,
      4.781245,
      5.428045,
      0.220816,
      0.177482,
      NULL,
      NULL,
      0.746948,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.575840,
      NULL,
      0.397389,
      1,
      NULL,
      NULL,
      2,
      1,
      1.348018,
      4,
      3,
      6,
      2,
      0.267102,
      NULL,
      2,
      1,
      5.761417,
      2,
      0.720012,
      0,
      3,
      NULL,
      0,
      0.519434,
      NULL,
      NULL,
      3,
      5,
      NULL,
      2.055281,
      2,
      1.124190,
      3.332689,
      NULL,
      3,
      1,
      2.708511,
      1.470878,
      2.465284,
      2,
      NULL,
      NULL,
      3,
      0.904399,
      5,
      NULL,
      1,
      0.161047,
      3.245013,
      9,
      0,
      0,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.734186,
      NULL,
      NULL,
      0.329766,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.576840,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.507031,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.707993,
      NULL,
      NULL,
      0.400810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.854980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.378399,
      1,
      0.002770,
      0,
      0.872996,
      NULL,
      0.916318,
      NULL,
      NULL,
      1.666723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587411,
      NULL,
      NULL,
      NULL,
      1.305027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851688,
      NULL,
      NULL,
      NULL,
      0.142503,
      NULL,
      NULL,
      NULL,
      3.225935,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.664850,
      NULL,
      NULL,
      NULL,
      2,
      0.695696,
      9.984042,
      0.024070,
      2.442123,
      NULL,
      1.254635,
      2,
      11,
      5,
      1.588807,
      NULL,
      NULL,
      0,
      1.820742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297569,
      NULL,
      0.810395,
      21,
      0.528684,
      0.157572,
      1,
      1.811657,
      0,
      1.036629,
      0.105703,
      0.259608,
      1,
      NULL,
      1,
      0.173285,
      NULL,
      0,
      0,
      0,
      0.584044,
      NULL,
      0.669941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.697183,
      0.985487,
      1.801325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523110,
      0.437161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818841,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.204095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966446,
      0.671583,
      NULL,
      1.954464,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.123521,
      NULL,
      1,
      NULL,
      1.549244,
      NULL,
      1.368424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800356,
      0,
      0,
      3,
      2.864881,
      1.265567,
      0,
      10.357997,
      0.765620,
      2.165611,
      1.492306,
      0,
      3,
      NULL,
      1,
      3.467837,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.450382,
      NULL,
      1,
      NULL,
      NULL,
      0.349665,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.099726,
      NULL,
      1.821831,
      2,
      NULL,
      0.594024,
      3,
      NULL,
      0.940497,
      NULL,
      NULL,
      2.297757,
      0,
      1.233748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917685,
      NULL,
      1.172577,
      NULL,
      1,
      3,
      8.454201,
      1.784610,
      1.380242,
      3.786087,
      43,
      13.922800,
      2,
      1.199686,
      3.921548,
      '34331',
      '',
      '',
      0.747811,
      '',
      '',
      '',
      2.324158,
      '23324',
      '',
      '');
commit;
end;
/


