set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '0022300',
      NULL,
      0.353725,
      NULL,
      3,
      '3424',
      3,
      1,
      3.227799,
      14,
      ' 4-27-1975',
      2,
      NULL,
      1.244477,
      NULL,
      NULL,
      ' 9-15-1982',
      2.719683,
      NULL,
      NULL,
      NULL,
      0.577615,
      ' 9-13-1993',
      NULL,
      ' 8- 0-1983',
      1.437404,
      1.258101,
      1,
      0.656701,
      1,
      1.276230,
      2.266489,
      1,
      1,
      1.820103,
      2.742962,
      11.518433,
      2,
      NULL,
      7.275845,
      1,
      NULL,
      7,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.928663,
      NULL,
      0,
      3,
      3.198902,
      1.469697,
      6,
      NULL,
      2,
      0.272182,
      0,
      3.977621,
      6.128134,
      6,
      3.550872,
      0.155957,
      1,
      3.983719,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.988536,
      NULL,
      1,
      7,
      NULL,
      0.227497,
      NULL,
      1.807442,
      NULL,
      0.057555,
      3,
      1.907347,
      1.057969,
      1,
      NULL,
      0,
      3,
      1.768658,
      0.355679,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      1.298034,
      0,
      0,
      0.554037,
      NULL,
      NULL,
      2.788506,
      4,
      0,
      NULL,
      5.201968,
      5.815257,
      NULL,
      4.674961,
      2.206282,
      1.423449,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1.937100,
      NULL,
      1.095791,
      0.069325,
      NULL,
      0,
      0.335076,
      4,
      2.102100,
      3.385443,
      NULL,
      3.493660,
      NULL,
      0,
      0.673034,
      1,
      NULL,
      1.517222,
      9,
      4.586302,
      9.358392,
      4.381702,
      1,
      3,
      6,
      1,
      3,
      0,
      1.713897,
      0,
      ' 9- 7-2002',
      3.356271,
      NULL,
      0.977821,
      1,
      NULL,
      1,
      NULL,
      1.305810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.883561,
      NULL,
      0.905822,
      2,
      1.575478,
      5.058249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.033658,
      NULL,
      7,
      1.369155,
      0.598229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.302709,
      1,
      1,
      2.199287,
      NULL,
      1.880387,
      7,
      1.986281,
      4,
      NULL,
      7,
      0.993773,
      4.592676,
      0.840460,
      3.717450,
      NULL,
      0,
      0.613795,
      NULL,
      0,
      NULL,
      ' 5-17-1999',
      6,
      '10- 1-1989',
      5.969780,
      3,
      1.291512,
      0.024691,
      0,
      NULL,
      1,
      NULL,
      1,
      0.918786,
      NULL,
      1.112753,
      19.076808,
      3.306255,
      1.629698,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0.854369,
      2.894244,
      0.766564,
      1,
      NULL,
      NULL,
      0.200357,
      1.946116,
      2,
      2.313731,
      0.546271,
      3,
      5,
      0,
      0.156038,
      1.480040,
      2,
      0.731631,
      1,
      NULL,
      1,
      NULL,
      1,
      1.220827,
      NULL,
      1,
      1,
      1,
      1.639632,
      6,
      NULL,
      1.348989,
      10,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      61.602177,
      3.351399,
      3.265995,
      NULL,
      37.362938,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      '41332',
      NULL,
      NULL,
      0.156742,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      34,
      129,
      14.025347,
      2.140534,
      29.417166,
      0,
      NULL,
      3.703646,
      0.282609,
      1,
      2,
      3.541355,
      1,
      0,
      2.685462,
      0,
      NULL,
      0.379054,
      NULL,
      NULL,
      1,
      2,
      1,
      1.532510,
      0,
      0,
      2.421708,
      0.095930,
      0.854649,
      0,
      1.306622,
      1.618051,
      0.304453,
      0.265289,
      0.567534,
      0,
      0.764172,
      1.534386,
      0.449984,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      0.901826,
      5,
      0.427096,
      1.622739,
      NULL,
      NULL,
      NULL,
      2,
      3.055024,
      NULL,
      3,
      1,
      1.166362,
      1.171491,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      1,
      1.571700,
      NULL,
      NULL,
      0,
      3,
      1,
      3.493754,
      1.251560,
      0.861405,
      NULL,
      0,
      3.116279,
      3,
      1,
      0.851463,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      7.673538,
      0,
      0,
      1.792763,
      NULL,
      NULL,
      NULL,
      1.262873,
      NULL,
      0.057989,
      3,
      0.395928,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      2.641876,
      1.874671,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.907065,
      1,
      NULL,
      3.588358,
      NULL,
      1.611499,
      5.905228,
      NULL,
      0.017135,
      1.732029,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.037715,
      NULL,
      NULL,
      1.057591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.097775,
      NULL,
      1.328307,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.227656,
      5.495928,
      7,
      1.432723,
      0.376294,
      NULL,
      NULL,
      1.744645,
      NULL,
      NULL,
      2,
      2.850517,
      NULL,
      NULL,
      3,
      1.392347,
      2,
      NULL,
      5.042890,
      NULL,
      NULL,
      2.387032,
      3.728208,
      2,
      NULL,
      3.401281,
      1.101265,
      1,
      NULL,
      2.251207,
      0.789888,
      3,
      0,
      8.333964,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.686935,
      NULL,
      1.704995,
      1.084438,
      1.098075,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.725053,
      NULL,
      NULL,
      0.023681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154792,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      3,
      3,
      NULL,
      1,
      2,
      3,
      NULL,
      3,
      3.114037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.651150,
      NULL,
      NULL,
      1.619049,
      NULL,
      1.801981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969926,
      1.126790,
      1.406188,
      NULL,
      0,
      0.902382,
      1.960161,
      NULL,
      NULL,
      0.978934,
      1.621037,
      NULL,
      1.388989,
      NULL,
      0.133591,
      NULL,
      1.209673,
      1.093854,
      1,
      NULL,
      2.594025,
      2.805866,
      0.823438,
      NULL,
      NULL,
      1.942443,
      0.438576,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      0,
      0.646925,
      NULL,
      0,
      0.713242,
      1,
      NULL,
      NULL,
      3.016921,
      3,
      NULL,
      1,
      1,
      0.007202,
      NULL,
      2,
      7.769455,
      NULL,
      NULL,
      2.412009,
      1,
      0.262518,
      6.479195,
      0,
      0.424868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.416007,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.053613,
      0.475312,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      14860,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.155486,
      1.353705,
      3,
      NULL,
      0.049312,
      1.399904,
      1.433554,
      NULL,
      0,
      1,
      1.107893,
      1.725064,
      1.403999,
      NULL,
      1,
      NULL,
      0.233056,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.260537,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      43.641761,
      1,
      NULL,
      NULL,
      NULL,
      0.443723,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.797948,
      NULL,
      0.867721,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.272036,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.731611,
      NULL,
      1.822915,
      NULL,
      NULL,
      NULL,
      0.644526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015435,
      3,
      NULL,
      0.921959,
      NULL,
      0.854969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.781769,
      NULL,
      0,
      1.676259,
      1.437024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920068,
      0.018118,
      NULL,
      0.168409,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.951761,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72.567103,
      NULL,
      3.696529,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499485,
      0,
      25.504336,
      27,
      1.968308,
      0.446647,
      2.869272,
      1.037808,
      0.717038,
      1.291380,
      1.450955,
      3,
      1.287503,
      0.862984,
      5.391181,
      NULL,
      6.837023,
      0,
      3.682653,
      3,
      0,
      3,
      0,
      1.355068,
      1.391553,
      1,
      NULL,
      3.744163,
      2,
      0.402926,
      1.109454,
      NULL,
      1,
      3,
      NULL,
      0.781483,
      NULL,
      1.359692,
      2.512302,
      NULL,
      NULL,
      0.372704,
      0,
      0,
      NULL,
      2.502450,
      0,
      0,
      0,
      2,
      0,
      0,
      1.274494,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050850,
      0,
      NULL,
      NULL,
      0,
      NULL,
      9.972030,
      3.093577,
      0,
      NULL,
      NULL,
      56,
      96.217094,
      1,
      0.514660,
      4.084094,
      '24222',
      '11343',
      NULL,
      0.598266,
      '',
      '',
      '',
      0.638086,
      '',
      '',
      '');
commit;
end;
/


