set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      4.402854,
      2.630367,
      3,
      3.574831,
      NULL,
      2.178810,
      2,
      '34',
      '03',
      16.057975,
      24.744209,
      '1301334',
      NULL,
      0.903419,
      5,
      3,
      '3120',
      0.876265,
      0.944622,
      NULL,
      NULL,
      ' 0-13-1997',
      23.675588,
      39,
      NULL,
      1.780670,
      NULL,
      ' 8- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 2-26-1978',
      2,
      0.769881,
      1.297419,
      2,
      1.904661,
      0.533780,
      3,
      3,
      NULL,
      NULL,
      NULL,
      12,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      NULL,
      0.145967,
      3,
      0,
      0.277784,
      0.092565,
      1.152401,
      1.554020,
      0.645814,
      1.463398,
      0,
      0.322010,
      NULL,
      5.646930,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1.755406,
      4.005111,
      1,
      0.070731,
      1,
      0.795507,
      2.478914,
      0.083695,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.226365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.720863,
      3.476945,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.611611,
      3,
      1.238713,
      0,
      1,
      2,
      1,
      NULL,
      2.203897,
      NULL,
      2,
      1.971781,
      5,
      0.214190,
      NULL,
      1.006655,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      1,
      0,
      1.807630,
      1,
      0.117116,
      NULL,
      1.886776,
      0.248756,
      1,
      1,
      0.513491,
      1.850733,
      0,
      NULL,
      0,
      2,
      1.237811,
      3.125748,
      1,
      1.334273,
      2.077458,
      1.752336,
      NULL,
      NULL,
      NULL,
      0.147298,
      NULL,
      5,
      0.189440,
      1.820412,
      NULL,
      1,
      4.419412,
      1,
      NULL,
      4.098846,
      5,
      2,
      NULL,
      1,
      1.100433,
      1.061829,
      NULL,
      33.956291,
      NULL,
      NULL,
      1.014265,
      3.981839,
      0,
      3.896264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567916,
      4,
      0.345678,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052918,
      NULL,
      NULL,
      NULL,
      NULL,
      1.766449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495217,
      1.424319,
      2,
      0,
      2,
      NULL,
      0.600105,
      NULL,
      NULL,
      NULL,
      0.075519,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1.987817,
      0,
      1.922890,
      1,
      1.733630,
      NULL,
      NULL,
      1.551605,
      NULL,
      NULL,
      NULL,
      1,
      1.404127,
      3.689343,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      2.438216,
      3.904277,
      NULL,
      1,
      0.870799,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.322099,
      0.946898,
      0.035727,
      1.311440,
      NULL,
      0.117945,
      1,
      0.190169,
      NULL,
      0,
      3.387439,
      NULL,
      9,
      7.270093,
      NULL,
      NULL,
      8,
      NULL,
      0.398495,
      0.856747,
      0,
      1,
      NULL,
      NULL,
      12,
      1.113402,
      0.117995,
      21.452916,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      '31412',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      2.159187,
      18,
      16,
      9,
      1,
      21,
      5,
      1.369662,
      2,
      2.800242,
      1.988105,
      0.366737,
      1.578199,
      NULL,
      NULL,
      1.185016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.366688,
      NULL,
      NULL,
      2.940732,
      1,
      NULL,
      0,
      2,
      NULL,
      1.628574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      6,
      3.291442,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.434142,
      NULL,
      NULL,
      NULL,
      0.783663,
      NULL,
      NULL,
      1.192133,
      1.843500,
      NULL,
      0,
      NULL,
      1.844337,
      1,
      0.742088,
      1.238993,
      2,
      1.089678,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      0,
      1.661234,
      NULL,
      3,
      3.897007,
      3.728821,
      NULL,
      3,
      1.418570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.865439,
      1.352205,
      NULL,
      NULL,
      0.077226,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.308304,
      3.838234,
      1,
      1,
      0.603938,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.528346,
      NULL,
      NULL,
      1.315075,
      1.642043,
      NULL,
      NULL,
      0.068272,
      2.222557,
      1,
      NULL,
      NULL,
      NULL,
      0.319574,
      NULL,
      NULL,
      0.583590,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.351379,
      NULL,
      NULL,
      0.843984,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697841,
      3,
      NULL,
      1.715506,
      2,
      2,
      NULL,
      NULL,
      1,
      1.024704,
      2.224206,
      NULL,
      NULL,
      1.833762,
      NULL,
      NULL,
      2.059569,
      3,
      0.853078,
      1.086961,
      NULL,
      0.708981,
      0.080576,
      0.045643,
      0.339987,
      1.115774,
      2,
      2.449730,
      3.117835,
      1.696330,
      2.440854,
      0,
      3.487574,
      3,
      3,
      3,
      NULL,
      NULL,
      2.214575,
      0.259835,
      NULL,
      2.322793,
      1,
      3.954261,
      1.213074,
      1,
      0,
      0.379612,
      NULL,
      1.954015,
      0,
      3.997301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188361,
      NULL,
      NULL,
      1.162250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.270631,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.067187,
      NULL,
      NULL,
      0.183669,
      0.313820,
      0.227290,
      1.289898,
      0.471627,
      3.507533,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.568730,
      NULL,
      NULL,
      NULL,
      0.696962,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.751864,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.639209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.408712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941193,
      NULL,
      NULL,
      NULL,
      1.325899,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647811,
      130,
      NULL,
      NULL,
      0.684084,
      1,
      1.955553,
      0.541537,
      0,
      1.712576,
      NULL,
      0.277160,
      0.932366,
      0.801204,
      NULL,
      1.414934,
      0.808809,
      NULL,
      0.575336,
      0,
      0.801061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564688,
      1,
      3.132702,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.737979,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.171515,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.032791,
      1,
      NULL,
      0.058346,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678893,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.594895,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492037,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.963904,
      0.770122,
      3.393951,
      0,
      NULL,
      NULL,
      NULL,
      82.325575,
      0,
      0.030670,
      3,
      '14411',
      '',
      '',
      1.246321,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


