set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7125247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0413343',
      NULL,
      1.971481,
      0,
      1,
      '3140',
      0,
      0.035224,
      NULL,
      NULL,
      ' 7-10-1991',
      7,
      NULL,
      4.131726,
      1.518868,
      0.941581,
      ' 5-29-1996',
      62,
      2.643549,
      NULL,
      14,
      2.987239,
      NULL,
      ' 4-25-2000',
      ' 3-14-1983',
      0.995508,
      1,
      1,
      NULL,
      0.242443,
      NULL,
      5,
      1.334626,
      NULL,
      157.260898,
      0.444764,
      10,
      6.880098,
      21.902863,
      NULL,
      6.636956,
      26.599771,
      4,
      NULL,
      3.597673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.794110,
      1,
      7,
      2.072034,
      5,
      0.672805,
      0.690670,
      NULL,
      4,
      3.462685,
      NULL,
      0,
      0,
      NULL,
      0,
      1.912516,
      NULL,
      0,
      5,
      1,
      2.789899,
      1.350766,
      NULL,
      NULL,
      0.129542,
      NULL,
      NULL,
      1.057801,
      1,
      1,
      1.098603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342658,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241018,
      0.627410,
      0,
      0.038516,
      1,
      1,
      0,
      5,
      0.879591,
      0.393386,
      0.381679,
      1.135128,
      0.624770,
      NULL,
      NULL,
      0.157823,
      NULL,
      1,
      NULL,
      1.936159,
      1,
      0,
      0,
      5.603934,
      1,
      NULL,
      1,
      1,
      1,
      0.327122,
      1.684372,
      0.210946,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      4.636137,
      4,
      1,
      1,
      NULL,
      3.459992,
      '10-21-1991',
      953.929479,
      ' 4-28-1977',
      4.300091,
      1.200603,
      2.400279,
      1.012652,
      1.471016,
      0.267721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234767,
      0,
      0,
      3.208173,
      0.711117,
      NULL,
      0.870303,
      3.190798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131918,
      1.753397,
      1.225575,
      0.970989,
      1,
      1.071454,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840297,
      NULL,
      0,
      2,
      1,
      NULL,
      21,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911595,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      2.112017,
      2.011686,
      1.923570,
      NULL,
      0.588483,
      3,
      6,
      88.778384,
      168,
      170.063649,
      138.190294,
      182.467705,
      NULL,
      NULL,
      134.352416,
      107,
      33,
      NULL,
      109.356733,
      NULL,
      11,
      10,
      NULL,
      9.279801,
      10,
      4,
      NULL,
      11,
      5.412950,
      0,
      0,
      2,
      2,
      1.323009,
      3,
      25.349478,
      3.780454,
      2.639474,
      NULL,
      59.826715,
      40.554671,
      NULL,
      NULL,
      1.895745,
      3.425236,
      '41333',
      '',
      '',
      0.959433,
      '',
      '',
      '',
      0.938850,
      NULL,
      NULL,
      '',
      2,
      NULL,
      10,
      39,
      0,
      63,
      2,
      4,
      NULL,
      3.635230,
      0.321872,
      2.087010,
      1,
      1,
      1.629864,
      1.673631,
      NULL,
      NULL,
      NULL,
      1,
      2.229683,
      3.539902,
      0.177294,
      0,
      2.444933,
      3.213363,
      0,
      1,
      1,
      0.317364,
      1,
      NULL,
      NULL,
      0.223340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      2,
      NULL,
      2.136497,
      2,
      1.956391,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.530135,
      0,
      1,
      NULL,
      NULL,
      1.993143,
      1,
      NULL,
      1,
      1,
      1.662665,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.414055,
      NULL,
      NULL,
      1.080042,
      NULL,
      NULL,
      6.416114,
      NULL,
      0.428544,
      1.293249,
      1.755485,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.561925,
      0.898998,
      1.493480,
      0,
      NULL,
      NULL,
      1.345201,
      NULL,
      NULL,
      3.471746,
      1.693903,
      1.481843,
      3,
      NULL,
      0.235092,
      2.872302,
      NULL,
      0.966582,
      7.157180,
      1,
      2.511126,
      1.162665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190764,
      NULL,
      NULL,
      1.976954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.008260,
      NULL,
      NULL,
      1.523010,
      NULL,
      NULL,
      3.966002,
      2.255136,
      1.374906,
      NULL,
      5,
      0.029370,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975611,
      NULL,
      NULL,
      2,
      1.405100,
      0.857718,
      NULL,
      NULL,
      NULL,
      9,
      3.503675,
      4.744468,
      2.414798,
      1.077882,
      NULL,
      NULL,
      NULL,
      3.033996,
      0,
      1.787400,
      0.140361,
      1,
      1,
      1,
      8.053388,
      0,
      5.143207,
      2,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      3,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      47,
      NULL,
      NULL,
      1.596883,
      NULL,
      NULL,
      2.151304,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.056718,
      1,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2.352137,
      2.832004,
      NULL,
      3.894652,
      0,
      NULL,
      1,
      0,
      NULL,
      1.640373,
      1,
      NULL,
      7.873935,
      4.578057,
      NULL,
      2.256403,
      1,
      0.497630,
      0,
      1.109053,
      1,
      NULL,
      3.665928,
      NULL,
      NULL,
      0.324933,
      1.104331,
      NULL,
      NULL,
      4.696263,
      11.540557,
      NULL,
      NULL,
      0.190933,
      NULL,
      NULL,
      NULL,
      1,
      0.064985,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144786,
      1,
      NULL,
      NULL,
      0.072689,
      NULL,
      NULL,
      NULL,
      0.768751,
      NULL,
      NULL,
      NULL,
      1.985083,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.544107,
      0,
      NULL,
      NULL,
      1.504846,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.031653,
      1.510249,
      NULL,
      NULL,
      0.692769,
      1,
      NULL,
      NULL,
      3.979319,
      0.397639,
      NULL,
      NULL,
      0.808476,
      NULL,
      NULL,
      NULL,
      3,
      154.646737,
      35.781450,
      1,
      1616.625049,
      566,
      0,
      NULL,
      NULL,
      3.879194,
      2.978141,
      0.485570,
      3.430539,
      17,
      NULL,
      2,
      156,
      2,
      1.619442,
      NULL,
      1.941289,
      18598.913670,
      1.823126,
      1,
      1.152897,
      0.275516,
      1,
      0.792617,
      0.445880,
      0.237183,
      0.053186,
      NULL,
      0,
      0.293003,
      1,
      1.389282,
      1.822394,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613021,
      NULL,
      NULL,
      NULL,
      1.302361,
      3,
      NULL,
      5,
      NULL,
      NULL,
      3.581924,
      1.604428,
      1.375266,
      1,
      1.441225,
      0.301940,
      1,
      1.229124,
      0,
      0.882859,
      0.162420,
      0.256011,
      0.963519,
      0,
      0.654782,
      0,
      NULL,
      NULL,
      NULL,
      1.896719,
      NULL,
      1.174282,
      1.891731,
      NULL,
      1.586271,
      1.980112,
      0,
      1,
      1.579346,
      1.768636,
      0,
      NULL,
      1.905244,
      1,
      2.047321,
      NULL,
      1.244514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.891327,
      NULL,
      1.331381,
      0.848909,
      3,
      12,
      0.526854,
      3.578670,
      0,
      1,
      NULL,
      1,
      4.596749,
      0.397918,
      0,
      NULL,
      '',
      '',
      1.380069,
      NULL,
      '',
      NULL,
      0.317168,
      '',
      '',
      '');
commit;
end;
/


