set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8918230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1401303',
      3.664025,
      1,
      1,
      2,
      NULL,
      0.702474,
      0,
      NULL,
      NULL,
      ' 5-25-1978',
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      3,
      NULL,
      32.238138,
      3.896432,
      NULL,
      ' 7- 1-1999',
      ' 0-18-1988',
      2.440174,
      3.433064,
      2,
      0.641091,
      1.639183,
      2,
      1,
      0.422198,
      NULL,
      32,
      0.684829,
      13.862010,
      2.534984,
      1.640088,
      18.887503,
      3.540065,
      5.919272,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113332,
      2.783214,
      3,
      9,
      0.821059,
      1.250534,
      10,
      NULL,
      0,
      5,
      NULL,
      NULL,
      2,
      NULL,
      1.880667,
      NULL,
      NULL,
      NULL,
      0.668156,
      3,
      0.796486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      1,
      0.691826,
      0.693544,
      1,
      2,
      1,
      0.015149,
      1.427074,
      3.294489,
      1.621213,
      1.353348,
      0.441030,
      NULL,
      2.162438,
      1.322568,
      0,
      2.149704,
      1.404427,
      NULL,
      1,
      1,
      0.617033,
      1,
      0,
      0.557546,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.535969,
      2,
      3.636134,
      1,
      0.765858,
      0.001766,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0.332278,
      1,
      0.713219,
      NULL,
      1.556128,
      0,
      2,
      1.290165,
      1.243818,
      0.848835,
      4.654753,
      0.089668,
      1,
      1.446027,
      3,
      1.709623,
      4.490928,
      4,
      4,
      1,
      5.189167,
      0,
      NULL,
      4,
      9.560673,
      1,
      7,
      4.313752,
      0.506506,
      NULL,
      5.783490,
      3.994385,
      NULL,
      75.800338,
      ' 2-22-1975',
      693.792741,
      3,
      1,
      1,
      7,
      0.972914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      6.019298,
      2.301428,
      0.117098,
      0.741254,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845047,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.351690,
      0.121697,
      2.891663,
      3.553583,
      3.654941,
      0.655303,
      NULL,
      1,
      9.418887,
      NULL,
      1.693757,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.276612,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.872251,
      3.892884,
      0,
      1.819444,
      0,
      2,
      26.591585,
      2.240831,
      0.044514,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      3.958097,
      NULL,
      0.338128,
      0,
      NULL,
      2,
      0,
      2.201719,
      5,
      0.217630,
      2,
      0,
      NULL,
      NULL,
      1,
      0.601455,
      1.471191,
      1.880710,
      0,
      0,
      1.499633,
      NULL,
      0,
      7,
      0.896290,
      NULL,
      7,
      3.236633,
      NULL,
      2,
      NULL,
      0,
      3.245631,
      1,
      2,
      1.898814,
      3.369589,
      9.129091,
      3,
      2,
      NULL,
      32,
      46.786732,
      57,
      3,
      1.354663,
      0,
      '21014',
      NULL,
      '',
      1.614853,
      '',
      '',
      '',
      1.078529,
      NULL,
      '',
      '',
      1,
      4,
      239.389383,
      NULL,
      1.196334,
      11,
      4.500747,
      1.250493,
      0,
      NULL,
      0.232873,
      0,
      1.992501,
      NULL,
      NULL,
      3,
      2,
      1.256320,
      NULL,
      NULL,
      3.337983,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      3,
      1.950517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.922642,
      9.903872,
      0.810188,
      1.288087,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.509401,
      NULL,
      NULL,
      0.729956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647124,
      NULL,
      NULL,
      1.617428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.125392,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.288479,
      0.310182,
      0.413970,
      0,
      NULL,
      1.224741,
      NULL,
      NULL,
      2,
      1.745963,
      1.747043,
      1,
      NULL,
      NULL,
      1.003402,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.996691,
      NULL,
      NULL,
      0.730943,
      NULL,
      NULL,
      0.141196,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.335390,
      1.603108,
      NULL,
      NULL,
      0,
      NULL,
      0,
      7,
      NULL,
      3.665546,
      0,
      NULL,
      NULL,
      2.504247,
      0,
      0,
      0,
      1,
      3,
      3,
      0.476732,
      1.295265,
      NULL,
      0.660961,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      2,
      2,
      NULL,
      NULL,
      3.312684,
      6,
      2,
      3,
      NULL,
      2,
      NULL,
      0,
      1.207753,
      0.153377,
      1.904746,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.595638,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.199243,
      NULL,
      NULL,
      1.357943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.996864,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1.226471,
      1,
      2,
      NULL,
      0,
      1.533006,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.715630,
      NULL,
      NULL,
      NULL,
      0.543532,
      NULL,
      NULL,
      NULL,
      1.513785,
      NULL,
      NULL,
      NULL,
      6.319313,
      NULL,
      NULL,
      NULL,
      3.292586,
      4.681244,
      5,
      2.804129,
      1.385778,
      8.152452,
      12.529125,
      2.549423,
      44.164695,
      4,
      0.101729,
      NULL,
      NULL,
      2,
      1.269033,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765434,
      NULL,
      0,
      373.804044,
      20.625437,
      1,
      NULL,
      1,
      1.212988,
      0,
      NULL,
      1.038025,
      2.503611,
      0,
      0.801917,
      0.019560,
      NULL,
      1.339561,
      3.752654,
      0.473782,
      0.459308,
      1.079005,
      3,
      NULL,
      2.211315,
      NULL,
      0,
      NULL,
      1.447533,
      NULL,
      0,
      NULL,
      3.607950,
      NULL,
      NULL,
      NULL,
      2,
      19.201277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.354557,
      NULL,
      0,
      NULL,
      0.260816,
      NULL,
      0.161057,
      NULL,
      0.626627,
      NULL,
      3.947693,
      NULL,
      0.512988,
      NULL,
      1.673256,
      NULL,
      1.807343,
      NULL,
      1.158644,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.710738,
      3.961684,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845588,
      0.729971,
      NULL,
      2,
      NULL,
      1,
      NULL,
      208,
      NULL,
      3,
      NULL,
      0.547647,
      NULL,
      NULL,
      NULL,
      1.723667,
      1.759500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.807055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.324350,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.606090,
      NULL,
      2.860382,
      NULL,
      2,
      1.721473,
      1.363025,
      18,
      30.321220,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.357176,
      1,
      3,
      NULL,
      2.741600,
      7,
      3,
      2,
      1,
      2.779052,
      0.909735,
      NULL,
      1.922879,
      1,
      NULL,
      1,
      3.823469,
      NULL,
      1,
      NULL,
      NULL,
      1.571249,
      3,
      NULL,
      0,
      1,
      NULL,
      1.962304,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.146644,
      1,
      NULL,
      0.793054,
      0.385083,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.999524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236453,
      NULL,
      0.338605,
      NULL,
      0.579725,
      NULL,
      3,
      3.793891,
      9.881859,
      NULL,
      NULL,
      2.195162,
      88,
      64.770245,
      2.833232,
      NULL,
      5,
      '32141',
      '32042',
      '',
      1.266288,
      '',
      '',
      NULL,
      0.999509,
      '',
      NULL,
      '');
commit;
end;
/


