set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      4,
      '4234301',
      3.826977,
      1.690754,
      0,
      3,
      '2301',
      4.675026,
      0,
      NULL,
      NULL,
      '10- 4-1990',
      NULL,
      34,
      NULL,
      1.530253,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.541621,
      ' 1- 2-1975',
      ' 3-24-2000',
      ' 6-23-1990',
      1.046913,
      2.885646,
      3,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.965880,
      9.655560,
      18.958012,
      5.700088,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.902391,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231216,
      1.944067,
      0,
      2.827772,
      6.893704,
      0,
      NULL,
      2.407967,
      10,
      10.299613,
      6,
      8.158008,
      7.215960,
      2,
      0,
      1,
      2.171583,
      1,
      1,
      4,
      0.353676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333574,
      0.691875,
      0,
      0.228189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829266,
      10.844654,
      0,
      1.443525,
      NULL,
      1.042374,
      1.554544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.928791,
      3,
      3.844340,
      0.493420,
      NULL,
      NULL,
      0.773291,
      0.739078,
      5,
      NULL,
      NULL,
      4,
      1.841742,
      0.293099,
      NULL,
      NULL,
      1,
      NULL,
      0.381158,
      NULL,
      1,
      1.447835,
      0,
      0.420151,
      NULL,
      4,
      0.640310,
      NULL,
      0.473228,
      0.838589,
      1,
      0.348635,
      3,
      4.965559,
      5,
      1.631377,
      9.614255,
      3,
      2,
      5.918742,
      NULL,
      1.109433,
      2,
      2,
      3,
      3,
      ' 1- 1-1990',
      21.266003,
      NULL,
      94,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      2.716923,
      0.876030,
      0.396634,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.083614,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.320612,
      NULL,
      0.337850,
      NULL,
      NULL,
      NULL,
      1.317971,
      7,
      NULL,
      5.745246,
      0,
      1.632655,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.758695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.836515,
      NULL,
      0.866957,
      1.611921,
      3.403245,
      25,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.541730,
      0,
      NULL,
      0.229904,
      1,
      1.581953,
      NULL,
      0.097991,
      1,
      0,
      2,
      1,
      2.472510,
      1,
      1.279095,
      3.068126,
      0.976904,
      0,
      0.682683,
      0,
      3.258365,
      0,
      1.803976,
      1,
      NULL,
      0,
      NULL,
      1.447469,
      NULL,
      0.726441,
      0,
      NULL,
      6,
      4,
      3.527136,
      10.046397,
      3.754259,
      0.923870,
      5,
      0,
      6,
      NULL,
      3.397990,
      2.086230,
      28,
      2,
      0.776342,
      27,
      NULL,
      41,
      5,
      1.341521,
      5,
      1.062989,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.309290,
      '',
      '',
      '',
      1.480332,
      35.454274,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.027050,
      0.358360,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871737,
      NULL,
      NULL,
      0,
      3,
      1.540022,
      1.065656,
      NULL,
      NULL,
      0.412852,
      2.497465,
      2.551907,
      1,
      NULL,
      NULL,
      3.545416,
      1.763946,
      2,
      2.638630,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      6.858700,
      0.952613,
      1.661589,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.153769,
      NULL,
      NULL,
      0.752760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.595293,
      NULL,
      NULL,
      0.259278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381206,
      NULL,
      NULL,
      1.247716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.645092,
      NULL,
      NULL,
      1.187275,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961811,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.778787,
      NULL,
      NULL,
      3,
      0,
      3,
      3,
      0,
      NULL,
      1,
      0.689255,
      3,
      4.695498,
      1,
      2.494187,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.686665,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.578368,
      3.187079,
      0.210389,
      1.611076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.848515,
      0.915470,
      0,
      1.697785,
      1.917025,
      2.585404,
      NULL,
      NULL,
      1.471540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581634,
      NULL,
      NULL,
      0.435680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.376164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.666729,
      0.253621,
      1,
      NULL,
      1,
      1.068392,
      0.543030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.894977,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791850,
      1.595965,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.459126,
      NULL,
      NULL,
      1.101915,
      NULL,
      NULL,
      1.529709,
      NULL,
      1,
      0,
      13001.959140,
      NULL,
      NULL,
      NULL,
      1.174560,
      0,
      1,
      1.254575,
      1.048980,
      1,
      1.167572,
      0.096510,
      0,
      1,
      1.738693,
      1.819618,
      0,
      0.020571,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.669892,
      0.884464,
      0.214065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.570582,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.973866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760466,
      0.039008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117888,
      NULL,
      1.974573,
      NULL,
      50.077897,
      NULL,
      2,
      NULL,
      1.753913,
      NULL,
      0.373427,
      0.682160,
      3,
      27,
      11.830874,
      1,
      NULL,
      NULL,
      NULL,
      0.069003,
      0.591168,
      0.554130,
      0,
      NULL,
      2,
      0,
      0,
      3.320800,
      NULL,
      0.309536,
      0.445752,
      1.833527,
      1.879267,
      NULL,
      NULL,
      3.037244,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.721953,
      NULL,
      0,
      0,
      NULL,
      1.719147,
      NULL,
      NULL,
      1.024727,
      0.584305,
      NULL,
      1.187741,
      1,
      NULL,
      NULL,
      0.971259,
      NULL,
      0,
      1.707690,
      NULL,
      NULL,
      1.877755,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4.537267,
      NULL,
      2.732164,
      1.657005,
      NULL,
      NULL,
      NULL,
      132,
      1.704200,
      1,
      5.153478,
      '01120',
      '44244',
      '',
      0,
      '',
      '',
      '',
      2.341866,
      NULL,
      '',
      '');
commit;
end;
/


