set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8720748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3343111',
      3.376346,
      NULL,
      3,
      1,
      '0032',
      2,
      0.046552,
      NULL,
      NULL,
      ' 0-15-1988',
      NULL,
      NULL,
      0,
      0,
      1,
      ' 7-18-1974',
      21.767427,
      3,
      66,
      NULL,
      NULL,
      ' 6-15-1980',
      ' 8- 5-1978',
      ' 4-19-1980',
      0.383025,
      1,
      1,
      NULL,
      1,
      NULL,
      6.130528,
      0.609103,
      1,
      99,
      0,
      5,
      0,
      156,
      56,
      NULL,
      22,
      0.035716,
      2.893321,
      2,
      NULL,
      1.114096,
      0.264193,
      1,
      0,
      1.251582,
      0.845588,
      1,
      0.627504,
      1.596702,
      NULL,
      3.043533,
      3.508934,
      6,
      1,
      1.208267,
      1.255682,
      0.015303,
      NULL,
      1.081387,
      NULL,
      5.776889,
      NULL,
      0.368368,
      0.368156,
      NULL,
      0.745972,
      2.929234,
      1,
      3.249436,
      1.455517,
      3,
      1.305445,
      NULL,
      NULL,
      1.393942,
      NULL,
      NULL,
      10.506155,
      NULL,
      0.342208,
      NULL,
      0,
      0.931513,
      NULL,
      3.669278,
      3,
      NULL,
      NULL,
      1.512299,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.750956,
      5.971850,
      NULL,
      4,
      0,
      1,
      2.766301,
      NULL,
      0.420911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.216432,
      1,
      0.601633,
      2.413787,
      NULL,
      1.945956,
      1.394371,
      6.865532,
      1,
      0.648798,
      0.500041,
      1.988831,
      1.360649,
      0.228673,
      1.800060,
      0,
      1,
      NULL,
      1,
      4.687591,
      3.042638,
      4,
      3.258188,
      0.976386,
      2,
      NULL,
      2,
      7.461064,
      1,
      NULL,
      0.041823,
      6.610309,
      1.217733,
      NULL,
      3,
      NULL,
      2.113645,
      NULL,
      11.755136,
      4.285029,
      3.717908,
      7,
      NULL,
      2,
      7.529780,
      NULL,
      ' 7- 4-1992',
      155.712204,
      ' 0-16-1981',
      1309.898692,
      2,
      0,
      NULL,
      2.986072,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908727,
      1,
      NULL,
      1.736130,
      1,
      3.395501,
      1,
      1.153454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.468695,
      NULL,
      4,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787615,
      0,
      1,
      NULL,
      1.000890,
      0,
      1,
      1.688098,
      444.102298,
      0,
      0.769788,
      55.453380,
      1934,
      1332.028198,
      1.181271,
      1,
      0.485585,
      2.313459,
      NULL,
      NULL,
      3.714229,
      0,
      0.056694,
      3.457290,
      NULL,
      3.428472,
      3.322738,
      NULL,
      9,
      7,
      NULL,
      179,
      66,
      56.177531,
      178.080261,
      28.039422,
      1.088052,
      1.377752,
      1,
      NULL,
      171.097608,
      NULL,
      NULL,
      0,
      9.893964,
      1,
      5.855988,
      NULL,
      4.391837,
      5.207179,
      9,
      3.961749,
      NULL,
      2.323538,
      0.451638,
      3.647561,
      2,
      1.714084,
      1.666654,
      0,
      2,
      NULL,
      18.208578,
      30,
      NULL,
      3,
      0.071528,
      0.661383,
      '04013',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0.030362,
      '03134',
      '',
      '',
      NULL,
      NULL,
      592.593942,
      45.632689,
      1.536731,
      30.119052,
      1.350990,
      39.006039,
      NULL,
      1.503022,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493519,
      0.187165,
      0,
      1,
      0.097775,
      NULL,
      0,
      0,
      0.946773,
      0,
      NULL,
      NULL,
      1.359902,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268687,
      NULL,
      NULL,
      1.706910,
      NULL,
      NULL,
      10.995898,
      5.977155,
      7.614531,
      0,
      1.231024,
      NULL,
      NULL,
      NULL,
      0.104452,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      7,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      2.527593,
      NULL,
      0.559853,
      1,
      0,
      NULL,
      3.971944,
      3.885468,
      0,
      1,
      0.832772,
      NULL,
      3.027505,
      0,
      0.235883,
      3.202928,
      3,
      0.476701,
      1,
      0,
      NULL,
      NULL,
      2.320818,
      0,
      0,
      NULL,
      1,
      2,
      0.729086,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491041,
      NULL,
      NULL,
      0,
      NULL,
      0.116836,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.952258,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.778752,
      1.857258,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.309803,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417930,
      1.678513,
      0,
      2,
      0.181792,
      0,
      4.183884,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.338104,
      NULL,
      NULL,
      2,
      1,
      2,
      3.689813,
      NULL,
      NULL,
      NULL,
      1,
      0.186716,
      3.774587,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      1,
      2,
      2.398246,
      1.708544,
      0,
      NULL,
      1.803889,
      0,
      5.420553,
      2.258990,
      4,
      2,
      0.477392,
      9,
      0,
      1.002103,
      NULL,
      1.234823,
      0,
      3.332226,
      NULL,
      NULL,
      0.045576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.793577,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.619374,
      NULL,
      NULL,
      1.693554,
      1.062655,
      0,
      0.893671,
      1.046753,
      3,
      3.165648,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.479206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.962257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394248,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.473930,
      NULL,
      NULL,
      2.010906,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.007412,
      0.967564,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.324615,
      NULL,
      NULL,
      NULL,
      1.029833,
      394,
      664.831184,
      1,
      NULL,
      NULL,
      1.806187,
      NULL,
      NULL,
      1.402070,
      NULL,
      NULL,
      NULL,
      5,
      4.330223,
      1.596861,
      NULL,
      NULL,
      0,
      1780.879289,
      1,
      141.261878,
      0,
      NULL,
      1.743764,
      0,
      0.845087,
      1.338053,
      0.493478,
      0.430820,
      NULL,
      1,
      NULL,
      1.641994,
      1,
      1.887794,
      1.757491,
      NULL,
      0.639120,
      NULL,
      1.801639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.276687,
      0.029081,
      2,
      1.220005,
      1.913474,
      1.838691,
      0,
      NULL,
      0.854743,
      3,
      NULL,
      1,
      1,
      NULL,
      1.547841,
      1,
      NULL,
      NULL,
      1,
      0.883933,
      0,
      NULL,
      1.109872,
      1,
      0.537376,
      1.594152,
      1,
      0.467784,
      0.861397,
      0.988991,
      NULL,
      0,
      0.025284,
      0,
      3.544745,
      0.880914,
      NULL,
      1.927351,
      0.000713,
      0.182726,
      1.870470,
      0.254962,
      0,
      1,
      3,
      NULL,
      0.806832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1.716939,
      8.748106,
      11.248786,
      3,
      1,
      3.354608,
      80.857748,
      74,
      4.119401,
      0,
      0.646910,
      '21342',
      '',
      NULL,
      1.340976,
      NULL,
      '',
      NULL,
      1.075825,
      '10142',
      '',
      '');
commit;
end;
/


