set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7322448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.083724,
      2,
      1,
      NULL,
      2.709858,
      0.189884,
      NULL,
      7.073067,
      ' 5-26-2002',
      0,
      NULL,
      5,
      NULL,
      0.214714,
      '10-21-1988',
      66,
      NULL,
      273.598476,
      180,
      NULL,
      NULL,
      NULL,
      ' 9-10-1975',
      NULL,
      1.272289,
      3,
      0.677809,
      1.907571,
      0,
      9.958865,
      0.920927,
      0.283115,
      29,
      1,
      NULL,
      NULL,
      NULL,
      18,
      9.119499,
      2,
      2.032779,
      1,
      7.683116,
      1.908125,
      1,
      0.591872,
      0,
      NULL,
      1.194952,
      NULL,
      3,
      0,
      1.450584,
      NULL,
      1.158452,
      3.772215,
      NULL,
      1.469577,
      NULL,
      NULL,
      0.309943,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.106197,
      NULL,
      0,
      4,
      0.057108,
      3,
      NULL,
      1.745047,
      0.810689,
      NULL,
      NULL,
      0.299017,
      NULL,
      NULL,
      1.460190,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995105,
      0,
      5,
      0,
      5.160385,
      5.479580,
      2.902741,
      NULL,
      1,
      0.272134,
      NULL,
      1.563459,
      NULL,
      4.125386,
      0,
      1.941660,
      1,
      1.355405,
      1.706793,
      NULL,
      1.185215,
      4.057957,
      1,
      0.440700,
      4,
      1,
      1.513342,
      3.190487,
      1.265925,
      NULL,
      1.577560,
      NULL,
      0.364699,
      3.584978,
      NULL,
      1,
      NULL,
      7.321666,
      5.297150,
      NULL,
      NULL,
      3.268691,
      1.395314,
      0,
      NULL,
      0.888501,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625871,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598277,
      1.439418,
      NULL,
      NULL,
      0.246736,
      0.199591,
      0,
      1.323870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.804114,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.589660,
      0.641381,
      1,
      1,
      0,
      1.362882,
      NULL,
      NULL,
      NULL,
      0.875483,
      4.997193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314719,
      1.052461,
      NULL,
      1,
      1.141397,
      0,
      1.616710,
      1.679745,
      NULL,
      1.269287,
      0,
      NULL,
      NULL,
      NULL,
      0.583821,
      0.350852,
      NULL,
      2,
      1,
      3,
      2.372765,
      0.074524,
      0,
      3,
      3.169299,
      3.777903,
      NULL,
      1.774009,
      NULL,
      1,
      2.912390,
      1.682191,
      1.272885,
      1.072859,
      NULL,
      0,
      2.548040,
      0.660521,
      0.558228,
      NULL,
      1.291413,
      NULL,
      0.264093,
      0,
      NULL,
      1.347781,
      2.880595,
      9,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.082339,
      4.647046,
      1.265030,
      0.793740,
      3,
      4.871717,
      2,
      1.032458,
      96,
      NULL,
      NULL,
      NULL,
      2.943740,
      1,
      4,
      '24411',
      '43111',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      141,
      30.941716,
      1.633486,
      5.628263,
      7.910335,
      25.528937,
      2.600842,
      1.761155,
      NULL,
      1.335261,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509999,
      NULL,
      0.285010,
      1,
      2,
      9,
      13,
      NULL,
      NULL,
      3,
      2.714465,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.363115,
      3.550967,
      3.808078,
      0.186334,
      NULL,
      NULL,
      NULL,
      0.658771,
      NULL,
      NULL,
      NULL,
      1,
      0.971623,
      NULL,
      12.466758,
      NULL,
      NULL,
      7.438768,
      NULL,
      NULL,
      2.984368,
      1.245396,
      0.468224,
      NULL,
      0.678757,
      1,
      0.135774,
      0,
      1.467277,
      1,
      1,
      1.765000,
      1.006501,
      1.777959,
      0,
      0.148726,
      1.726665,
      NULL,
      NULL,
      0.442128,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      9,
      NULL,
      1,
      1,
      1.021323,
      NULL,
      NULL,
      NULL,
      0.786680,
      NULL,
      NULL,
      NULL,
      1.457950,
      NULL,
      NULL,
      NULL,
      0.507679,
      3,
      0.280914,
      2,
      0.307620,
      NULL,
      3,
      0.537043,
      3.724621,
      6.797920,
      3.099634,
      3,
      1,
      NULL,
      1,
      2.856540,
      2.491817,
      0.664828,
      9.566063,
      1.120123,
      0,
      NULL,
      NULL,
      0.759158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.373884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.693464,
      NULL,
      NULL,
      1.381958,
      NULL,
      NULL,
      5,
      5.693810,
      1.147998,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751150,
      1,
      1.265834,
      3.727506,
      1.966985,
      NULL,
      1.436668,
      1.292252,
      0,
      5,
      1.439826,
      5,
      1,
      1,
      NULL,
      1.913934,
      0.399288,
      3,
      3,
      0.632836,
      NULL,
      3,
      NULL,
      NULL,
      1.582473,
      5.172015,
      NULL,
      5,
      4,
      2.210693,
      1,
      2.770966,
      7.702380,
      0,
      1,
      0.445309,
      1.448202,
      0,
      2.736663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088172,
      NULL,
      NULL,
      1.258589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.327183,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.745632,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.138097,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.154345,
      NULL,
      NULL,
      NULL,
      NULL,
      3.786155,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.916736,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      8,
      3.530049,
      NULL,
      NULL,
      1.663076,
      NULL,
      NULL,
      NULL,
      0.804149,
      9,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      0.383115,
      1,
      NULL,
      NULL,
      NULL,
      9,
      1,
      2.333170,
      12.103786,
      0.878379,
      9943.708393,
      1179.306572,
      0.190675,
      3.556966,
      0.480413,
      NULL,
      0.098422,
      0,
      0,
      0.343046,
      NULL,
      0,
      NULL,
      1.305372,
      0.070606,
      NULL,
      1.295363,
      NULL,
      0,
      0.189166,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.758578,
      NULL,
      0.310785,
      NULL,
      0,
      NULL,
      152,
      NULL,
      0,
      22,
      21,
      2,
      0.078688,
      1,
      NULL,
      0.290073,
      NULL,
      1.943461,
      NULL,
      0,
      NULL,
      3.149762,
      NULL,
      0,
      NULL,
      0.210498,
      NULL,
      0,
      NULL,
      0.938002,
      NULL,
      0.763985,
      NULL,
      NULL,
      NULL,
      1.670588,
      NULL,
      0.639357,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.263958,
      NULL,
      1.115774,
      1.385598,
      NULL,
      0.252969,
      2.783331,
      NULL,
      3,
      0,
      0,
      0.694039,
      NULL,
      2,
      3.234546,
      3,
      NULL,
      1.545319,
      14.938353,
      NULL,
      0,
      1,
      0.813842,
      1.873121,
      0,
      0,
      2,
      NULL,
      0.480395,
      2.017820,
      3,
      NULL,
      8.430066,
      1,
      NULL,
      NULL,
      1,
      0,
      0.919646,
      0.191801,
      0.276085,
      1,
      0.120199,
      2.267505,
      2,
      1.830926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521677,
      0.053472,
      NULL,
      NULL,
      0.965368,
      NULL,
      5,
      9,
      3.273905,
      NULL,
      0,
      3,
      84.494005,
      42,
      NULL,
      NULL,
      1,
      '43201',
      '23042',
      NULL,
      0.755632,
      NULL,
      '',
      '',
      1.551793,
      '3003',
      '3113',
      '');
commit;
end;
/


