set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7525070';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '4030',
      NULL,
      0.389299,
      5.703467,
      37,
      ' 7-29-1998',
      38.901114,
      NULL,
      NULL,
      1.901507,
      0.366920,
      ' 2-25-2003',
      33.696827,
      1.839652,
      3.342153,
      35,
      1.036934,
      NULL,
      NULL,
      ' 3-18-2002',
      2,
      0.599724,
      0.766037,
      0,
      0,
      2,
      0,
      2.881066,
      NULL,
      NULL,
      NULL,
      10.917651,
      4.602776,
      7,
      19,
      1,
      NULL,
      4,
      2,
      8.213863,
      0,
      NULL,
      1.150621,
      1,
      0.823833,
      0.220724,
      0.504466,
      0.956164,
      0,
      1.782765,
      0,
      0.886949,
      2.885897,
      1,
      3.002741,
      1.927682,
      0,
      1.248757,
      0,
      1,
      0,
      1.240685,
      NULL,
      1.557557,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487164,
      0,
      0.858437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580260,
      1.734108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165991,
      1,
      0,
      NULL,
      0,
      0,
      0.503594,
      0.772517,
      1.481730,
      NULL,
      1.522549,
      0,
      0,
      1,
      NULL,
      0,
      1.611911,
      1.574987,
      1,
      NULL,
      0,
      4.566300,
      1,
      1.671565,
      1.120371,
      1.759496,
      2,
      4,
      1.183437,
      3.702750,
      NULL,
      6.408232,
      2,
      9,
      NULL,
      1,
      4.906422,
      NULL,
      7,
      3,
      NULL,
      NULL,
      1.776945,
      NULL,
      0,
      1,
      0.572522,
      0.856913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.604658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288919,
      1,
      0.941155,
      NULL,
      1.470617,
      0.996130,
      0.841611,
      1.072614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.807003,
      1,
      0.716485,
      1.267848,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204612,
      NULL,
      1.312381,
      0.467489,
      1.780272,
      1.201709,
      NULL,
      0.147657,
      NULL,
      1.673728,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541387,
      0,
      1,
      3.597886,
      0.750380,
      NULL,
      NULL,
      0,
      3.499369,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.807036,
      3,
      NULL,
      1,
      1.289631,
      1.539400,
      0.112468,
      0,
      1,
      0,
      1.675066,
      0,
      1.257018,
      1,
      NULL,
      NULL,
      0.858931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526066,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449119,
      NULL,
      NULL,
      '',
      '',
      1.850698,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      327.476296,
      26,
      3,
      21.254129,
      1,
      14.821892,
      2.533330,
      2,
      3.796883,
      0,
      0,
      4,
      NULL,
      1.222760,
      NULL,
      NULL,
      0.681842,
      0.344690,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      11,
      1.869022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.308444,
      0.126714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068676,
      0.093173,
      0.899463,
      NULL,
      0,
      2,
      3.242895,
      0,
      0.772243,
      1,
      NULL,
      0,
      1,
      1,
      0.110534,
      1,
      NULL,
      NULL,
      1.699723,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.765374,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.463895,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.136910,
      1.884334,
      9,
      0,
      NULL,
      1.118884,
      0.442159,
      0.602575,
      NULL,
      NULL,
      5,
      2,
      1.883890,
      0,
      3.289062,
      0,
      NULL,
      0,
      0,
      5,
      NULL,
      0.887817,
      NULL,
      NULL,
      NULL,
      0.546681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.632966,
      2,
      NULL,
      NULL,
      3.806812,
      1.586012,
      7.034787,
      5,
      4,
      0,
      3.796211,
      9.977783,
      NULL,
      NULL,
      NULL,
      3.071905,
      0.390010,
      1.648759,
      0,
      15,
      3,
      0.842775,
      NULL,
      NULL,
      2.906201,
      4,
      1.221517,
      2,
      1,
      1,
      0.437380,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.003640,
      2.368747,
      3,
      NULL,
      8.595017,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247756,
      3.372593,
      6,
      1,
      1.789127,
      0,
      1.771261,
      1.586522,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395394,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.977925,
      NULL,
      NULL,
      3.709131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039499,
      1.775288,
      1.790973,
      0.420081,
      0.165368,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.122927,
      1,
      NULL,
      NULL,
      13.437668,
      NULL,
      NULL,
      NULL,
      12.857995,
      2,
      NULL,
      NULL,
      8.826179,
      NULL,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      17.403659,
      0.234451,
      NULL,
      NULL,
      14.243832,
      0,
      NULL,
      NULL,
      0.422160,
      3.451683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      25,
      49.093329,
      2,
      1888,
      NULL,
      0.956387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935264,
      NULL,
      NULL,
      0.644281,
      NULL,
      NULL,
      0,
      NULL,
      0.795427,
      1593.484585,
      43.579519,
      0,
      0.884002,
      1.544069,
      2,
      0,
      2.831637,
      0,
      NULL,
      NULL,
      0.953320,
      1.273859,
      1.519599,
      0,
      2,
      1,
      NULL,
      1.075343,
      3,
      NULL,
      1,
      NULL,
      2.528659,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.668023,
      NULL,
      148,
      NULL,
      NULL,
      NULL,
      55.012670,
      2,
      0.030365,
      15.026256,
      NULL,
      2.109257,
      NULL,
      1.531547,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.911460,
      NULL,
      0.054923,
      NULL,
      2.775993,
      NULL,
      0,
      NULL,
      2.472590,
      NULL,
      1,
      NULL,
      1.577356,
      NULL,
      2.071572,
      NULL,
      1,
      NULL,
      0.171724,
      3,
      0,
      1.710122,
      NULL,
      1.272632,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.057409,
      NULL,
      NULL,
      NULL,
      1.727936,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.149800,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1224,
      NULL,
      23.649425,
      NULL,
      1.737213,
      NULL,
      1.824183,
      NULL,
      1.415369,
      0,
      1.190380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.397522,
      NULL,
      0,
      NULL,
      0.009298,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2.126588,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.436278,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      15,
      NULL,
      2,
      0,
      13.297387,
      1.634750,
      3,
      5.877950,
      1.860031,
      NULL,
      0.782968,
      2.878915,
      3,
      5.006581,
      NULL,
      2,
      0,
      7.997582,
      2.112047,
      NULL,
      NULL,
      0,
      11,
      3.230063,
      NULL,
      0.999416,
      3.009224,
      0.517520,
      1,
      NULL,
      3.452499,
      2.477440,
      3,
      0,
      1.244865,
      2.409938,
      NULL,
      NULL,
      2,
      2,
      0,
      4,
      12.284412,
      8,
      NULL,
      15.732793,
      NULL,
      7.267601,
      3.233893,
      3.098295,
      0,
      3.682221,
      0.563954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.478657,
      0,
      0.600102,
      7,
      6.621040,
      11,
      3,
      1,
      1,
      NULL,
      NULL,
      2.600659,
      0,
      6,
      '10423',
      '34034',
      '21141',
      3.954880,
      '03024',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


