set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '32',
      16,
      11,
      '1104023',
      NULL,
      1.355328,
      NULL,
      NULL,
      '2231',
      2.004592,
      1,
      NULL,
      NULL,
      ' 8-23-1981',
      119,
      2,
      NULL,
      0,
      0.542754,
      ' 9-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2.682914,
      ' 0-26-1983',
      '11-14-1984',
      ' 5- 7-2003',
      0.584458,
      NULL,
      0,
      NULL,
      3,
      1.071118,
      1.296629,
      0.750124,
      0,
      NULL,
      2,
      10.474704,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.990175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554644,
      2.238715,
      5.814100,
      0,
      3,
      1,
      1,
      3,
      0.314974,
      1,
      6,
      1,
      1,
      0.708907,
      0.119583,
      1.857551,
      2.744483,
      NULL,
      4.080492,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.926882,
      NULL,
      NULL,
      0,
      1,
      0,
      1.501104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268844,
      1,
      1.324759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.793707,
      NULL,
      5,
      NULL,
      2,
      0.881420,
      1.971024,
      NULL,
      1,
      1,
      0.825688,
      2.539971,
      0,
      0.641770,
      1,
      NULL,
      1.780254,
      NULL,
      NULL,
      0.796403,
      4.883199,
      1.980597,
      5.290220,
      0,
      2,
      NULL,
      1.494415,
      1,
      2.675622,
      0,
      1.723781,
      1.100981,
      0,
      4,
      4,
      1,
      1,
      NULL,
      8.684243,
      NULL,
      0,
      2,
      1,
      0.324436,
      NULL,
      0.405139,
      ' 6-18-1980',
      583,
      ' 7- 7-1974',
      NULL,
      1,
      1,
      1,
      1.485485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.317960,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265101,
      0,
      1.854504,
      1.327922,
      2.071083,
      0,
      2.672403,
      NULL,
      2.277439,
      0.518409,
      0,
      3.285352,
      2.406160,
      NULL,
      NULL,
      NULL,
      1.658083,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.773141,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      15,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523599,
      3,
      1,
      2.703599,
      0.423903,
      2,
      2.628670,
      1.404743,
      3,
      NULL,
      0.766931,
      NULL,
      NULL,
      2,
      3.964086,
      NULL,
      0.963152,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.383128,
      NULL,
      0,
      1,
      1.224816,
      0,
      0.547519,
      0,
      0.040962,
      NULL,
      4.107505,
      4.076453,
      10.592239,
      NULL,
      5,
      2,
      3,
      3,
      2.287081,
      0,
      26,
      3,
      1,
      33,
      NULL,
      47,
      52.759175,
      3.316930,
      0,
      0.672718,
      '20411',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.711297,
      '',
      '',
      '',
      3,
      1.655299,
      174.561061,
      51.198055,
      1.492947,
      41.785208,
      9,
      9.770249,
      5,
      1.261780,
      1.459921,
      2.607514,
      0,
      NULL,
      NULL,
      0.144743,
      NULL,
      NULL,
      2,
      1.859708,
      NULL,
      1.299657,
      NULL,
      NULL,
      1.895318,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      0.772252,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483669,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.786684,
      7,
      1.337814,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.569359,
      2.441581,
      0.392669,
      0.810733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326866,
      0.958720,
      2,
      0,
      2,
      1,
      1,
      NULL,
      1,
      1.931135,
      1.358994,
      0.824492,
      3.924692,
      NULL,
      0.334009,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.247773,
      1,
      1,
      0,
      0.708685,
      3.295823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.736117,
      NULL,
      NULL,
      0.165702,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.545536,
      NULL,
      NULL,
      1,
      1.442465,
      0.779322,
      2.366281,
      NULL,
      NULL,
      1.339230,
      NULL,
      NULL,
      1.028885,
      NULL,
      NULL,
      1.832891,
      NULL,
      NULL,
      3.234486,
      3.453400,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.818606,
      NULL,
      0,
      NULL,
      0.554509,
      0,
      2.762736,
      2,
      1,
      NULL,
      0,
      NULL,
      4,
      5,
      5,
      0,
      NULL,
      NULL,
      3.067342,
      0,
      5,
      1.617933,
      1.990570,
      NULL,
      1.871544,
      1.082609,
      0.087611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296263,
      NULL,
      NULL,
      1.941728,
      NULL,
      NULL,
      7.302728,
      NULL,
      NULL,
      0,
      0,
      1,
      0.220262,
      1,
      2,
      0,
      NULL,
      NULL,
      0.445443,
      1,
      NULL,
      NULL,
      5.510178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756919,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.156387,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.714935,
      NULL,
      NULL,
      NULL,
      1.097859,
      NULL,
      NULL,
      NULL,
      0,
      0.677281,
      NULL,
      NULL,
      0,
      1.738877,
      NULL,
      NULL,
      2.518955,
      NULL,
      NULL,
      NULL,
      0.093300,
      0,
      NULL,
      NULL,
      2.124610,
      0,
      NULL,
      NULL,
      NULL,
      0.113745,
      NULL,
      NULL,
      1.394222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768619,
      3,
      4.943236,
      5,
      0,
      123.936725,
      55.959470,
      1,
      13.596702,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5.714623,
      0,
      1.154096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5.835936,
      1.309843,
      1,
      NULL,
      0,
      2.278323,
      1,
      NULL,
      NULL,
      0.258411,
      1.986252,
      1.055909,
      1.186456,
      0,
      1,
      0.145471,
      0,
      3,
      NULL,
      1.590718,
      0.357697,
      1,
      NULL,
      0,
      NULL,
      2.895984,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.337627,
      NULL,
      NULL,
      NULL,
      0,
      46,
      NULL,
      1.123167,
      0.914356,
      3.150395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968880,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.870223,
      NULL,
      NULL,
      NULL,
      0.761418,
      NULL,
      0.839833,
      NULL,
      0.000792,
      NULL,
      1.729235,
      NULL,
      0.097367,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.252173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.533270,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.937593,
      NULL,
      1.859654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019263,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.524425,
      3,
      1,
      3.802354,
      1,
      3,
      NULL,
      14.512373,
      1.345526,
      NULL,
      1,
      1,
      1,
      0,
      1.496930,
      1.734887,
      3.037641,
      0.640751,
      2.033659,
      NULL,
      1.480119,
      NULL,
      NULL,
      0.831402,
      NULL,
      0,
      0,
      1.689545,
      1.888631,
      NULL,
      2.559536,
      NULL,
      NULL,
      1,
      0,
      1.535767,
      0,
      0.737191,
      1,
      1,
      1,
      1.895333,
      1.263112,
      1,
      1,
      NULL,
      0.106931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475194,
      0.240161,
      1.272103,
      1,
      NULL,
      1,
      5.161298,
      1,
      2,
      2,
      NULL,
      1.349074,
      37.888421,
      81,
      NULL,
      4,
      NULL,
      '31442',
      '',
      NULL,
      1.891224,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


