set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7411597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      2.179310,
      1.632418,
      2.408864,
      3,
      4,
      0.087061,
      2,
      '413',
      '32443113',
      48.782987,
      78.469979,
      '1311243',
      NULL,
      1,
      6,
      2,
      NULL,
      5.333871,
      0,
      NULL,
      NULL,
      ' 3-17-1992',
      145.650371,
      NULL,
      NULL,
      NULL,
      2.468369,
      '11- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 8-29-1978',
      ' 0-10-1983',
      NULL,
      0.866930,
      NULL,
      NULL,
      1.830116,
      0.768528,
      1,
      1.240795,
      1,
      1.260368,
      2,
      5.545241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755886,
      3.319874,
      NULL,
      0,
      3.078757,
      1.781701,
      0.984853,
      0.372332,
      NULL,
      1.151556,
      NULL,
      NULL,
      1.510228,
      1.730939,
      NULL,
      5,
      NULL,
      3,
      1.662867,
      1,
      NULL,
      7.948900,
      NULL,
      NULL,
      4.034047,
      0.945752,
      1.309677,
      1.622508,
      3,
      NULL,
      NULL,
      0.220282,
      NULL,
      5.987581,
      5.264800,
      0.745713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.705143,
      1.015282,
      0.793499,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080732,
      1.983289,
      NULL,
      NULL,
      0.285288,
      0.116774,
      NULL,
      NULL,
      NULL,
      0.815159,
      NULL,
      NULL,
      1,
      0.602286,
      8.327083,
      NULL,
      0.772321,
      NULL,
      7.172040,
      1,
      0,
      1.044447,
      3.613436,
      6.221792,
      0.265578,
      3,
      NULL,
      0.728728,
      0.294819,
      1.239733,
      0,
      NULL,
      1.343490,
      4.700138,
      3.036217,
      NULL,
      NULL,
      NULL,
      3,
      7,
      NULL,
      0.580976,
      8.477959,
      9,
      4,
      5.239995,
      1,
      7.505338,
      NULL,
      NULL,
      1.039659,
      NULL,
      1,
      NULL,
      6.840439,
      5.268903,
      0,
      2.948297,
      2.619907,
      0.113000,
      ' 8- 7-1984',
      326,
      ' 1- 9-1974',
      19,
      NULL,
      2,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.947759,
      5,
      0.760529,
      5,
      1,
      NULL,
      2.805687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.264019,
      1,
      3,
      1.615073,
      4.625982,
      0.587256,
      5,
      NULL,
      0.333092,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.237706,
      1,
      1.222956,
      NULL,
      NULL,
      3,
      1.829888,
      NULL,
      NULL,
      NULL,
      3.132677,
      1,
      2,
      0.236846,
      0,
      2.688105,
      3.612461,
      3.581323,
      0.955474,
      2,
      0.167246,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      0.572889,
      NULL,
      1,
      0,
      1.746219,
      0.543510,
      0.542467,
      1,
      0.108390,
      1.790329,
      NULL,
      1.351916,
      1.390392,
      1,
      NULL,
      2.358825,
      1,
      2,
      2.134669,
      5,
      3.622199,
      NULL,
      3,
      4.201911,
      1.067244,
      3.526827,
      1.453588,
      23,
      1,
      1.440061,
      NULL,
      NULL,
      NULL,
      1,
      5.360414,
      4,
      NULL,
      '23420',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.262396,
      30.264027,
      101.196373,
      9,
      1,
      35,
      1,
      0,
      1.355135,
      3.376543,
      3.344452,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.614521,
      NULL,
      1.077359,
      1,
      NULL,
      NULL,
      0.541244,
      1.624287,
      1,
      2.984952,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.811189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.508445,
      0.055273,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926075,
      NULL,
      NULL,
      0.487627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.321160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340679,
      NULL,
      NULL,
      3.512248,
      0.862991,
      0,
      0.869390,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.225621,
      0.443744,
      0,
      1.984560,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.458839,
      NULL,
      0,
      0.008325,
      NULL,
      NULL,
      6.999063,
      0.626986,
      0.514036,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.518168,
      1.090939,
      1.686806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.441902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.342342,
      0.916277,
      1.251862,
      1.921780,
      0.317103,
      1.236520,
      0.289098,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.753536,
      3,
      1,
      2,
      3,
      3.030672,
      7.540398,
      6,
      3,
      1,
      2.028995,
      1,
      1.626849,
      2,
      2,
      3.002425,
      NULL,
      3,
      0.323389,
      1.216110,
      3,
      6,
      NULL,
      4.941332,
      7,
      2.530605,
      3.343984,
      1.798978,
      NULL,
      4,
      NULL,
      1.793819,
      0.940571,
      0,
      0.368960,
      3.117242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.850233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.385042,
      NULL,
      NULL,
      1.566245,
      NULL,
      NULL,
      2.760836,
      NULL,
      NULL,
      3,
      3,
      1,
      0.095951,
      NULL,
      0,
      0,
      NULL,
      7.732584,
      4,
      NULL,
      NULL,
      33,
      16,
      NULL,
      NULL,
      2,
      1.269438,
      NULL,
      NULL,
      0.594417,
      1,
      NULL,
      NULL,
      3.992539,
      1.742839,
      NULL,
      NULL,
      1.216061,
      NULL,
      NULL,
      NULL,
      1.535996,
      NULL,
      NULL,
      NULL,
      2.983183,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.126428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.434020,
      3.968388,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033697,
      1.488504,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.831328,
      1,
      NULL,
      NULL,
      15.990912,
      4.049379,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      1,
      NULL,
      1.618152,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.574541,
      NULL,
      NULL,
      1.147291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      350,
      1.928365,
      0.920971,
      2.026133,
      NULL,
      2,
      1.904007,
      0.544355,
      1,
      2.984219,
      0.436490,
      0,
      NULL,
      0,
      NULL,
      1.204736,
      0.027161,
      1,
      NULL,
      2,
      NULL,
      1.544910,
      NULL,
      NULL,
      NULL,
      0.358612,
      NULL,
      0,
      NULL,
      3.864368,
      NULL,
      6,
      NULL,
      0.985445,
      18.695306,
      33.574208,
      2,
      1.324941,
      5.567667,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.867133,
      NULL,
      1.876415,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.377005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382842,
      2.465321,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.379332,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.769215,
      1.837669,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723537,
      1,
      NULL,
      1.436835,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      0,
      NULL,
      1.052244,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.198066,
      1.968649,
      0,
      NULL,
      29.170563,
      3,
      2.463913,
      3.679765,
      3,
      5,
      4,
      3.347792,
      NULL,
      2.639407,
      2,
      3,
      NULL,
      1.448773,
      3.112103,
      2.356946,
      0.863514,
      0.870254,
      1,
      1,
      NULL,
      1,
      2.435164,
      NULL,
      1,
      0.330945,
      NULL,
      1.426714,
      0.075523,
      NULL,
      0,
      2.581117,
      NULL,
      NULL,
      1.428332,
      NULL,
      1,
      NULL,
      NULL,
      0.358804,
      1.556615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      9,
      0.601036,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.478826,
      NULL,
      '03033',
      '',
      '',
      1,
      '',
      '',
      '',
      1.224300,
      '',
      NULL,
      '');
commit;
end;
/


