set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8406340';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1233100',
      2,
      NULL,
      NULL,
      3,
      '3420',
      3,
      NULL,
      NULL,
      NULL,
      ' 6-17-2002',
      7.156395,
      NULL,
      1,
      0.752122,
      1.820855,
      NULL,
      42.596616,
      NULL,
      211.162899,
      36.360474,
      NULL,
      ' 6-20-2002',
      ' 9- 0-1997',
      ' 1-20-1975',
      1.038383,
      0.949031,
      3,
      0,
      0.277842,
      1.421169,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.316540,
      5.904328,
      5.681760,
      4,
      NULL,
      8,
      5.157029,
      3.396168,
      0.438055,
      1,
      1.855050,
      1.988107,
      NULL,
      1,
      3,
      1.316860,
      0.242213,
      0,
      1,
      NULL,
      4.487826,
      NULL,
      2.030666,
      1,
      NULL,
      0,
      0,
      1,
      1.557339,
      2,
      3,
      0.642531,
      2,
      1,
      1.734530,
      3.399429,
      4.911859,
      1.967355,
      3.199511,
      4.842671,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.230089,
      7,
      1.398746,
      0,
      1,
      NULL,
      0,
      0,
      0.791499,
      NULL,
      2,
      NULL,
      3.865020,
      NULL,
      0.292246,
      0.608705,
      NULL,
      1,
      3.204047,
      1.562176,
      0,
      0.736667,
      1.913013,
      3,
      1,
      0,
      NULL,
      NULL,
      1.743983,
      NULL,
      NULL,
      0.243344,
      1.278994,
      1.237085,
      1.696114,
      NULL,
      2,
      4,
      0,
      NULL,
      5,
      0.317275,
      0,
      NULL,
      6.121355,
      NULL,
      NULL,
      0.943737,
      0,
      1.568855,
      NULL,
      0,
      NULL,
      2.709215,
      NULL,
      NULL,
      1.638718,
      0,
      NULL,
      0.033116,
      0.323939,
      0.449652,
      1.305530,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      7,
      3,
      3.218947,
      6.387431,
      NULL,
      3.548570,
      0,
      3.345122,
      2.501452,
      ' 2- 5-1998',
      616,
      ' 7-12-1989',
      NULL,
      3,
      0.341322,
      1.698946,
      0.502254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799521,
      1.643814,
      NULL,
      0.115651,
      0,
      1,
      0,
      1.324131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064631,
      1.160295,
      5.679446,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.672203,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.701930,
      1.845052,
      NULL,
      0.674370,
      0.321897,
      1.752660,
      3.895011,
      3.592779,
      1.417605,
      1.568095,
      NULL,
      NULL,
      NULL,
      0.756525,
      0.520239,
      0,
      0.202317,
      0.265071,
      0,
      NULL,
      2.115619,
      3,
      2.588561,
      2,
      3,
      1,
      NULL,
      3.595968,
      2,
      3,
      2.137050,
      1.870974,
      3,
      0,
      1.807688,
      3.019405,
      NULL,
      1.685022,
      NULL,
      NULL,
      0.280426,
      NULL,
      NULL,
      4.452896,
      1,
      NULL,
      1,
      1.943697,
      2.549050,
      3,
      3,
      3,
      3.131177,
      4,
      0.632065,
      0,
      0,
      61,
      2.946303,
      NULL,
      NULL,
      54.063886,
      30.072797,
      7,
      1.705736,
      1.568745,
      2.771758,
      '34233',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      '12120',
      '',
      NULL,
      2.288827,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      5.540358,
      NULL,
      2.291454,
      0.096963,
      0,
      1.071953,
      1.618878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919386,
      NULL,
      NULL,
      1,
      1,
      0.232746,
      3.916185,
      3,
      1.715312,
      0.838030,
      1,
      0,
      1.933745,
      3.919959,
      0,
      2,
      3,
      NULL,
      1.928823,
      9.038558,
      NULL,
      3.656226,
      16,
      NULL,
      2,
      2.636490,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.187514,
      3.734232,
      0.332756,
      1,
      2.817887,
      2.606897,
      3.388446,
      2,
      0,
      NULL,
      NULL,
      1.835665,
      2,
      NULL,
      1,
      2.090364,
      NULL,
      NULL,
      0.248916,
      1.765236,
      0.715211,
      1.993468,
      0,
      2.012812,
      1,
      1,
      1.663828,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6.813599,
      4.884153,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.285903,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.992472,
      NULL,
      NULL,
      3,
      2.876085,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.002820,
      NULL,
      NULL,
      1.906634,
      NULL,
      NULL,
      1.199326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.456792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870810,
      NULL,
      NULL,
      4.015045,
      1.842549,
      2.443061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263474,
      NULL,
      NULL,
      1.713736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237322,
      2.635954,
      0,
      3,
      1,
      2.112457,
      NULL,
      2.989216,
      NULL,
      0.655043,
      1.680753,
      NULL,
      1,
      6.680668,
      1.238840,
      0.674089,
      NULL,
      NULL,
      2.778688,
      0.759164,
      1.899965,
      0.830291,
      0.694030,
      0,
      1.165682,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454112,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.564708,
      NULL,
      NULL,
      1.368175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.285903,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3.741905,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237348,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.855160,
      NULL,
      NULL,
      NULL,
      2.029845,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.241061,
      NULL,
      NULL,
      NULL,
      1.838916,
      NULL,
      NULL,
      NULL,
      1.895306,
      NULL,
      NULL,
      0.905960,
      0,
      NULL,
      1.826008,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.396440,
      NULL,
      NULL,
      1.450454,
      NULL,
      NULL,
      1.609536,
      NULL,
      0,
      100,
      40,
      1,
      0,
      NULL,
      1,
      0.027516,
      0,
      1.236126,
      0.933615,
      0.316127,
      0.833009,
      NULL,
      1,
      1.516453,
      NULL,
      1.328643,
      0.776801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183790,
      0,
      1.583304,
      1,
      NULL,
      0,
      1.448715,
      1.928690,
      NULL,
      0.607234,
      2,
      1.291624,
      NULL,
      NULL,
      NULL,
      3.330497,
      0,
      NULL,
      NULL,
      0.834082,
      NULL,
      1.414981,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.809917,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.543985,
      0.943383,
      NULL,
      3.699438,
      0.252539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697172,
      NULL,
      1,
      NULL,
      0.881890,
      NULL,
      1,
      7,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      '02110',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '41340',
      '',
      '');
commit;
end;
/


