set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000221';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0213032',
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.359598,
      NULL,
      NULL,
      33,
      ' 2-10-1993',
      114,
      NULL,
      4,
      NULL,
      1,
      NULL,
      47,
      1,
      36,
      58.150679,
      1,
      NULL,
      NULL,
      NULL,
      0.838394,
      0.649076,
      0.256921,
      0.643712,
      1.637418,
      0.749580,
      1,
      0,
      1,
      29.186545,
      11.689368,
      7,
      NULL,
      25,
      10,
      0,
      14.239462,
      2,
      1.139518,
      1.078873,
      1,
      1,
      1,
      0.479354,
      1.365950,
      0.812164,
      0,
      1.434624,
      NULL,
      0.589061,
      NULL,
      6.475190,
      3,
      3,
      0.922531,
      0,
      1.547358,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.245818,
      NULL,
      0.404586,
      1,
      0.479717,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.187062,
      1.979742,
      1.340952,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      1.613045,
      1.644140,
      0.531188,
      NULL,
      NULL,
      0.837289,
      0,
      2.986852,
      1.988211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.824594,
      1,
      1.539737,
      4,
      NULL,
      0.878739,
      NULL,
      1,
      4.848200,
      0.133775,
      2,
      NULL,
      0.411532,
      1,
      1,
      1,
      NULL,
      1,
      2.766479,
      2.292776,
      0,
      NULL,
      1.644448,
      NULL,
      4.172128,
      2.468158,
      3.122875,
      3.807385,
      NULL,
      1.014735,
      2,
      4.115878,
      NULL,
      3.216223,
      NULL,
      3,
      1.778448,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.391407,
      4.656654,
      2,
      ' 8- 3-1974',
      92,
      NULL,
      252.552862,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.574789,
      1,
      1.497692,
      1.538523,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158771,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351321,
      0.712787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.478551,
      NULL,
      NULL,
      1.825140,
      0.002557,
      1,
      NULL,
      1.911933,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      2.834687,
      3,
      1,
      2,
      2.663326,
      2,
      3,
      NULL,
      0.869055,
      2,
      3.663999,
      2,
      NULL,
      1,
      0.671915,
      0.201463,
      1.971582,
      0,
      0.002683,
      NULL,
      1,
      1,
      0,
      1.018962,
      0,
      0.183014,
      1,
      NULL,
      6.260438,
      9,
      3,
      NULL,
      0.837499,
      0.113470,
      2,
      3,
      NULL,
      2,
      1.593711,
      2.336902,
      NULL,
      2,
      0.286935,
      85,
      NULL,
      NULL,
      NULL,
      1.201936,
      NULL,
      0,
      '24303',
      '22104',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      14.098501,
      140,
      12.745642,
      0,
      NULL,
      1,
      6,
      4.577769,
      0,
      NULL,
      1.537463,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.057458,
      0.266025,
      NULL,
      NULL,
      1.001920,
      NULL,
      NULL,
      1.461628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.445323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.313069,
      7.273371,
      0.101787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.221461,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.874529,
      0.020931,
      NULL,
      3.359832,
      0.032888,
      NULL,
      NULL,
      1.559636,
      NULL,
      1.342167,
      0.246948,
      0,
      3,
      1.996210,
      2.480411,
      1,
      2,
      3.258063,
      1,
      NULL,
      0,
      1,
      1.266259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.676817,
      NULL,
      0.396816,
      3.983634,
      0,
      NULL,
      NULL,
      NULL,
      0.670427,
      NULL,
      NULL,
      NULL,
      0.418897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.418466,
      0.208626,
      2.998203,
      1.321717,
      0,
      1.522711,
      NULL,
      1.112823,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      1.501755,
      1.569017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552966,
      NULL,
      NULL,
      1.551697,
      NULL,
      NULL,
      2.271841,
      NULL,
      0,
      2,
      NULL,
      2,
      2.498362,
      9.669364,
      1,
      8,
      9.195072,
      1.859564,
      9,
      8,
      3,
      NULL,
      3.143726,
      1.806814,
      NULL,
      2,
      3.532059,
      2.027459,
      2.780380,
      3.521617,
      4,
      6.145589,
      0,
      NULL,
      3,
      1.549087,
      2.766815,
      2,
      NULL,
      2.168058,
      2.335741,
      NULL,
      NULL,
      NULL,
      0,
      9,
      5.573745,
      3.249089,
      NULL,
      3,
      NULL,
      0,
      4,
      5,
      0.608896,
      1,
      NULL,
      0,
      0,
      2.196773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.673650,
      2,
      1,
      NULL,
      NULL,
      1.758351,
      2.109404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.995171,
      0,
      NULL,
      NULL,
      3.536753,
      1,
      NULL,
      NULL,
      2.427337,
      3.295353,
      NULL,
      NULL,
      NULL,
      1.258575,
      NULL,
      NULL,
      1.457359,
      0.908876,
      NULL,
      NULL,
      1.711700,
      1,
      NULL,
      NULL,
      4,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      16.669162,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      1.372787,
      2.665114,
      1,
      3,
      1,
      1.913568,
      NULL,
      1.162887,
      1,
      0.293171,
      0.130684,
      NULL,
      0.317725,
      0,
      NULL,
      0,
      0.400703,
      2.083331,
      NULL,
      0,
      NULL,
      3.248186,
      NULL,
      3,
      NULL,
      0.051164,
      NULL,
      2,
      NULL,
      73,
      NULL,
      1.409722,
      20,
      NULL,
      1,
      3,
      3,
      NULL,
      3.859692,
      NULL,
      1,
      NULL,
      1.744978,
      NULL,
      NULL,
      NULL,
      3.354051,
      NULL,
      0.636509,
      NULL,
      3.880795,
      NULL,
      0.704515,
      NULL,
      0,
      NULL,
      0.984657,
      NULL,
      1,
      NULL,
      0.772045,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      7.828932,
      NULL,
      0.894395,
      NULL,
      1.980833,
      NULL,
      0.265646,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629157,
      1,
      NULL,
      1,
      NULL,
      0.613638,
      NULL,
      NULL,
      NULL,
      1.661480,
      NULL,
      1.007122,
      NULL,
      1,
      NULL,
      0.854199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241884,
      NULL,
      NULL,
      0,
      NULL,
      1.939142,
      NULL,
      25.935485,
      NULL,
      0.877744,
      NULL,
      3.790808,
      NULL,
      1.003692,
      NULL,
      1.373309,
      NULL,
      NULL,
      2.833702,
      1.341913,
      3,
      1.545599,
      3.025341,
      NULL,
      1,
      11.227920,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3.362816,
      NULL,
      2.376262,
      3.286378,
      NULL,
      0.358602,
      1,
      1.969860,
      0,
      0.965562,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      2.225614,
      2.914089,
      1,
      2,
      3.248683,
      0,
      NULL,
      0,
      0.170688,
      1,
      1.604841,
      3.606152,
      3.802217,
      1.581106,
      3,
      0.644325,
      0.671040,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368021,
      1,
      0,
      0,
      0,
      0.963689,
      7.747239,
      9.992446,
      2,
      3,
      NULL,
      3,
      50.181181,
      NULL,
      1,
      NULL,
      7.795979,
      '21230',
      '04213',
      '42111',
      0.701219,
      '13124',
      '',
      '',
      6,
      '404',
      '142',
      '414');
commit;
end;
/


