set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      5.535125,
      3,
      0.410552,
      4.669385,
      2.718707,
      2,
      2,
      '422',
      '42341031',
      80,
      62.359948,
      NULL,
      3.815150,
      NULL,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      '10- 4-1979',
      61,
      50,
      NULL,
      0,
      NULL,
      ' 9- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      5.546326,
      NULL,
      NULL,
      ' 7-11-1993',
      1,
      1,
      2,
      2.037480,
      1.385280,
      1.809672,
      NULL,
      0.977052,
      0,
      NULL,
      11.236907,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528237,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495073,
      1,
      0.337556,
      1.578052,
      1.441841,
      0,
      1.112091,
      4,
      NULL,
      0.604872,
      NULL,
      3,
      0.739727,
      5.996550,
      NULL,
      1,
      9,
      2,
      NULL,
      0.343629,
      1,
      2.037909,
      1.883040,
      1,
      NULL,
      7,
      1,
      1.059258,
      0,
      1.117734,
      0.182839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.804912,
      NULL,
      7.258431,
      3,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1.680747,
      2.853011,
      1.260747,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.143718,
      1.454838,
      NULL,
      5.242245,
      0,
      NULL,
      NULL,
      0.514574,
      NULL,
      NULL,
      5.611292,
      0.966021,
      NULL,
      0,
      5,
      6.351680,
      5.173230,
      0,
      0,
      6,
      0.794867,
      2,
      NULL,
      4.629509,
      0.566685,
      0,
      NULL,
      1,
      1.312730,
      NULL,
      0,
      0,
      2.341398,
      3,
      4,
      1,
      NULL,
      5.475632,
      NULL,
      0,
      5,
      5,
      1.360274,
      6.869848,
      0.317459,
      2,
      8,
      9,
      0.498412,
      0,
      6.303753,
      2.970344,
      NULL,
      6,
      5.035271,
      1,
      3,
      3.701406,
      NULL,
      310,
      '10- 2-1982',
      63.544566,
      1.504024,
      0,
      1.247159,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.399204,
      2.305874,
      1,
      2.771703,
      3.347057,
      0.431910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815935,
      NULL,
      1.711668,
      1.417376,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.371704,
      0.045331,
      1.414132,
      NULL,
      NULL,
      NULL,
      0.079727,
      5,
      2.143995,
      4.584010,
      1.553875,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6.459265,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180136,
      0,
      1.982969,
      1.247391,
      1.821422,
      1,
      1,
      NULL,
      NULL,
      3,
      1.429070,
      NULL,
      NULL,
      NULL,
      1.653208,
      1.408528,
      0.761684,
      1.584520,
      2.904438,
      1.745896,
      NULL,
      3.788518,
      NULL,
      3,
      0,
      1.010018,
      0.997878,
      1.096828,
      3,
      NULL,
      1.069867,
      4.012958,
      1,
      0,
      1,
      0,
      1,
      0.043245,
      1,
      0.494195,
      NULL,
      1.755456,
      NULL,
      1.299165,
      0,
      0,
      NULL,
      3,
      6,
      4,
      7,
      NULL,
      5,
      1.199028,
      NULL,
      0,
      0,
      2.901461,
      32.550203,
      1,
      NULL,
      48.781710,
      NULL,
      NULL,
      NULL,
      3.445985,
      0,
      4,
      '43321',
      NULL,
      '',
      0.925500,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.503194,
      3,
      NULL,
      12.076287,
      0.750037,
      NULL,
      NULL,
      NULL,
      NULL,
      2.942641,
      3,
      0,
      0,
      NULL,
      NULL,
      0.742294,
      NULL,
      NULL,
      1,
      0,
      0.217761,
      1.219419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.669942,
      2.097063,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.148369,
      NULL,
      NULL,
      2.629039,
      0,
      8.660961,
      0,
      1.107898,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.364061,
      NULL,
      1.105327,
      NULL,
      3,
      NULL,
      1.565606,
      2,
      NULL,
      NULL,
      0,
      1.080489,
      0,
      2.254487,
      NULL,
      1,
      2.811904,
      2,
      3.909039,
      2,
      1.408106,
      0,
      1.310755,
      1,
      0,
      1.479247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.640926,
      2,
      3,
      3.508843,
      5.286546,
      2.259394,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.251167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299146,
      2.169061,
      0,
      3.636980,
      NULL,
      1.839056,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.372617,
      NULL,
      NULL,
      7,
      3,
      2.233125,
      1.231793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.246278,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.905395,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      3.533913,
      2,
      7.300566,
      1.711263,
      2.134527,
      NULL,
      4.950600,
      NULL,
      1.788043,
      NULL,
      2,
      NULL,
      1,
      1.171654,
      NULL,
      1.448156,
      3,
      6,
      NULL,
      0,
      3,
      0.005638,
      0.186366,
      3.037542,
      2,
      2.457998,
      2.768278,
      3.605105,
      NULL,
      3,
      3,
      NULL,
      7,
      NULL,
      5.189708,
      4,
      1,
      3.463587,
      0,
      7,
      7.379018,
      1,
      1.926751,
      0,
      NULL,
      0.321295,
      1.550863,
      NULL,
      NULL,
      0.998630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.361724,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.598659,
      NULL,
      NULL,
      1.717167,
      NULL,
      NULL,
      1.924943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217002,
      NULL,
      NULL,
      0,
      0.425829,
      NULL,
      0.146619,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160234,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965675,
      NULL,
      NULL,
      NULL,
      1.285729,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.247047,
      NULL,
      NULL,
      NULL,
      3.516229,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.346288,
      NULL,
      NULL,
      NULL,
      0.923758,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.613667,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.544424,
      NULL,
      1,
      1,
      0,
      2,
      10,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.489083,
      14.996211,
      3,
      0.454489,
      0,
      1.990180,
      1.173381,
      1.672391,
      0.280545,
      0,
      0,
      1.457204,
      1.740657,
      NULL,
      0.779284,
      0,
      NULL,
      1,
      1,
      0.699199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729777,
      1.566252,
      1.982366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618752,
      0.787331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.503283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550610,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513606,
      NULL,
      2,
      NULL,
      2,
      NULL,
      69.670645,
      NULL,
      3.837565,
      NULL,
      0.883709,
      NULL,
      0.097776,
      1,
      2.633234,
      18,
      NULL,
      1.744401,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907563,
      3,
      3.077432,
      2.100615,
      NULL,
      4.783955,
      2.358585,
      6.401011,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.594262,
      NULL,
      NULL,
      0.913354,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.159866,
      NULL,
      NULL,
      1.520212,
      0,
      NULL,
      1.907345,
      1.880899,
      NULL,
      0.275271,
      2,
      NULL,
      0,
      1.063518,
      NULL,
      2,
      1.525606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835089,
      1,
      NULL,
      0.869068,
      NULL,
      1.458095,
      NULL,
      NULL,
      NULL,
      2.997462,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.922819,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.983317,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.531758,
      NULL,
      NULL,
      2.690123,
      5.994691,
      NULL,
      NULL,
      NULL,
      61.648447,
      NULL,
      1,
      2.729507,
      3,
      '42344',
      '12033',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


