set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7829517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '33',
      23.554560,
      22,
      '1331304',
      NULL,
      0.663487,
      0,
      0,
      '4402',
      2.726555,
      0.584618,
      NULL,
      NULL,
      ' 1-10-1980',
      20,
      7.022735,
      NULL,
      1,
      1.245233,
      '11-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6-14-1977',
      ' 0-28-1979',
      '10-25-1990',
      0.815249,
      1.342012,
      0,
      0,
      0.072604,
      3.230935,
      2.110847,
      0.712823,
      1.016198,
      141.889034,
      5,
      8.588013,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409786,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.313312,
      3,
      0.470118,
      NULL,
      1,
      0,
      1,
      1.257573,
      NULL,
      NULL,
      0,
      1.693670,
      1,
      1.505779,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.458858,
      6,
      1.287702,
      1,
      0.714895,
      0,
      2,
      1.765674,
      NULL,
      0,
      3,
      0,
      1.769029,
      0.157819,
      0.316536,
      3,
      3.428234,
      3,
      1,
      1,
      0,
      0,
      NULL,
      0,
      3,
      3.139785,
      0.935872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.600272,
      NULL,
      1,
      0.981596,
      0,
      1,
      1,
      0.109265,
      0.886564,
      0.255193,
      0.217302,
      NULL,
      0,
      0.282739,
      NULL,
      NULL,
      1,
      0.426482,
      0.432315,
      1,
      1,
      1.319094,
      NULL,
      0,
      0,
      1.299147,
      0,
      1.561290,
      0,
      0,
      NULL,
      3,
      7,
      7.227696,
      6.165891,
      NULL,
      9,
      NULL,
      0.139174,
      3,
      1,
      0.749124,
      3,
      NULL,
      ' 8- 6-1977',
      3353.140543,
      ' 9-22-1983',
      172,
      1.294094,
      0.291254,
      0.883941,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397211,
      1,
      NULL,
      0.688416,
      0,
      0.004235,
      1.971619,
      1.099274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      214,
      3.845775,
      1,
      2,
      3.151161,
      NULL,
      1,
      1,
      0.867065,
      NULL,
      NULL,
      0.314101,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524178,
      3,
      4,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.445062,
      NULL,
      0.634753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510915,
      1.181980,
      NULL,
      NULL,
      NULL,
      3.421227,
      NULL,
      0.975351,
      NULL,
      NULL,
      NULL,
      2.017854,
      1.528867,
      NULL,
      1,
      1,
      3.554270,
      0,
      NULL,
      0.539996,
      3,
      3,
      2.358931,
      0,
      1.896748,
      1,
      1.000042,
      1.343528,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.509146,
      1,
      0.019047,
      1.533376,
      NULL,
      1,
      0.693478,
      0.661352,
      2.041559,
      NULL,
      5,
      8,
      NULL,
      7,
      2.472754,
      0.049270,
      3,
      1.056932,
      3,
      1.794628,
      17,
      3,
      2,
      90.950099,
      NULL,
      48,
      15,
      3.834698,
      0,
      3.071558,
      NULL,
      NULL,
      NULL,
      0.773213,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      47,
      271.773272,
      6,
      NULL,
      NULL,
      44,
      16.102485,
      5,
      2,
      NULL,
      0.842105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.770146,
      1.732080,
      1,
      NULL,
      1,
      0.096744,
      1.143723,
      NULL,
      NULL,
      3.881838,
      1.778979,
      0,
      1.931907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.712635,
      0,
      1.831540,
      0.149447,
      NULL,
      NULL,
      1.042110,
      3.568421,
      4.443190,
      1.245010,
      0.360825,
      NULL,
      NULL,
      NULL,
      2.051422,
      0,
      3.233086,
      NULL,
      0.171185,
      1.440791,
      2.682688,
      3.462462,
      1.815318,
      2,
      0.160390,
      NULL,
      NULL,
      2.944296,
      2.877457,
      NULL,
      0,
      1.793453,
      1.199516,
      NULL,
      0.248877,
      0,
      0.539959,
      1.944452,
      0,
      3,
      1,
      NULL,
      1,
      0.551962,
      0,
      0,
      0.033700,
      NULL,
      NULL,
      NULL,
      3,
      1.798219,
      NULL,
      1,
      3.075143,
      1.680339,
      0,
      NULL,
      NULL,
      NULL,
      1.341714,
      1.675007,
      3,
      3.883244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.886672,
      0.498484,
      1.414012,
      NULL,
      NULL,
      NULL,
      0.052687,
      3.149156,
      3.536790,
      1.453812,
      0.747093,
      1,
      NULL,
      NULL,
      1.753829,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.193450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.891481,
      NULL,
      NULL,
      1.879418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.660550,
      NULL,
      NULL,
      3.460339,
      0.000857,
      NULL,
      3.461673,
      NULL,
      NULL,
      3.812684,
      2,
      3.523022,
      NULL,
      NULL,
      NULL,
      0.188260,
      0,
      3.719996,
      3,
      4.404730,
      2.446682,
      0.995528,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.462603,
      2.401786,
      1,
      NULL,
      NULL,
      NULL,
      7,
      5.490116,
      4,
      2,
      0.720973,
      3.586959,
      7.297900,
      1,
      0,
      0.450486,
      0.162235,
      NULL,
      1.828037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.594158,
      NULL,
      NULL,
      2.328670,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.874605,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1.497982,
      0.366388,
      0,
      3.642296,
      0,
      NULL,
      2.443666,
      0,
      1.078106,
      NULL,
      11,
      44.384622,
      20,
      NULL,
      0.572807,
      0,
      1.297196,
      NULL,
      1.622038,
      NULL,
      0.057607,
      NULL,
      1.775188,
      0,
      1,
      NULL,
      1.424972,
      0,
      NULL,
      NULL,
      1.360699,
      0,
      NULL,
      NULL,
      NULL,
      0.188452,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.932792,
      NULL,
      NULL,
      1.331056,
      0.565341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284383,
      1,
      0.499487,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.426346,
      0.481897,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.633932,
      0,
      NULL,
      1.961150,
      NULL,
      NULL,
      NULL,
      7,
      7,
      1.168413,
      NULL,
      2.705015,
      0.392797,
      NULL,
      NULL,
      NULL,
      0.484066,
      417,
      98.639916,
      NULL,
      219,
      13,
      0,
      NULL,
      NULL,
      1.845620,
      92.073703,
      NULL,
      0.862301,
      NULL,
      102,
      1,
      2.794364,
      10.007303,
      1,
      NULL,
      1,
      NULL,
      4.674671,
      1,
      NULL,
      1.168821,
      1,
      NULL,
      NULL,
      0,
      0.433898,
      1.107323,
      NULL,
      1.869717,
      1.397632,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      3,
      1,
      0,
      7,
      1.659642,
      NULL,
      3.425910,
      0,
      0,
      NULL,
      0.617383,
      NULL,
      1,
      1,
      NULL,
      0.752458,
      1,
      0.247251,
      0,
      2.333631,
      1,
      1,
      1,
      0,
      1.364145,
      NULL,
      0,
      NULL,
      1.292320,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.384671,
      1.867418,
      0.610618,
      0,
      NULL,
      0,
      1.684961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.052455,
      3.690608,
      NULL,
      1,
      0,
      2,
      0,
      1,
      1,
      NULL,
      0.265074,
      0.748376,
      NULL,
      0.374102,
      0,
      1,
      1.402027,
      0.536177,
      0.754283,
      1.455105,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      39.677607,
      3.918112,
      NULL,
      0,
      NULL,
      1,
      3,
      0.840309,
      1,
      6.578990,
      0.792036,
      NULL,
      0.720132,
      NULL,
      NULL,
      40,
      17.607760,
      1.725919,
      4.260569,
      NULL,
      '23212',
      '14042',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


