set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4424244',
      NULL,
      1,
      4,
      1,
      '4142',
      1,
      1,
      NULL,
      NULL,
      NULL,
      24.011615,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1989',
      35,
      1,
      268.736780,
      111.398898,
      3,
      ' 5-27-1996',
      ' 1-20-1980',
      ' 7- 6-1996',
      2.602137,
      2,
      1.100551,
      3,
      1.370609,
      0,
      1,
      0,
      0,
      NULL,
      6.507284,
      18.637196,
      9.464586,
      24,
      23.739095,
      8.585151,
      8,
      6,
      3.944330,
      7,
      1.246550,
      1,
      NULL,
      NULL,
      0,
      0.402939,
      0,
      NULL,
      1.505776,
      1,
      1.535981,
      3,
      1.310109,
      5.555155,
      3.086135,
      1.726564,
      1.850973,
      1.100431,
      3.779003,
      0,
      2.400222,
      4,
      1.545377,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      3,
      0.656956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.899868,
      1.330226,
      0.907659,
      1.808078,
      0.567344,
      1.071962,
      NULL,
      0,
      0.288501,
      NULL,
      0,
      NULL,
      1,
      0.440139,
      0,
      0.791892,
      4,
      1.726796,
      3.867008,
      2.336316,
      0.982155,
      4.534399,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      6.354915,
      7,
      0.890731,
      7,
      0,
      5.528841,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      2.296793,
      1.891090,
      0,
      0,
      0.872815,
      1,
      7,
      9.605298,
      11,
      NULL,
      9,
      3,
      5.466406,
      NULL,
      7,
      6,
      4.298213,
      6,
      8.911146,
      1.448288,
      1,
      3,
      9,
      2,
      7,
      NULL,
      3,
      5.023003,
      8,
      NULL,
      7,
      0.901023,
      2,
      1,
      ' 7-12-1987',
      58.564772,
      NULL,
      281,
      1,
      0,
      0.359695,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579095,
      0.528371,
      NULL,
      1.403844,
      3,
      5.097460,
      0,
      0.186086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133215,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.102307,
      0,
      NULL,
      5,
      NULL,
      NULL,
      2.075528,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636742,
      1,
      3.012721,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.002717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.167455,
      1.767479,
      0.693998,
      1.809994,
      0,
      NULL,
      13.894514,
      0.318635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.038643,
      0,
      1.608777,
      1.361839,
      0.575531,
      NULL,
      1.983166,
      NULL,
      1,
      1.813014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.308769,
      NULL,
      0.665471,
      0,
      0.186760,
      1,
      1.441186,
      0,
      1.449049,
      NULL,
      NULL,
      1.375684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.829003,
      NULL,
      34.842803,
      29.844393,
      7,
      4.256966,
      1,
      3.919617,
      '12244',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      0.625384,
      NULL,
      NULL,
      '',
      2.918322,
      NULL,
      NULL,
      NULL,
      1.846351,
      25,
      0.181415,
      NULL,
      2.354831,
      NULL,
      1.536917,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.348234,
      5,
      13.118312,
      1,
      NULL,
      NULL,
      0.944125,
      8.245785,
      1.673425,
      NULL,
      0,
      3.471433,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220253,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931994,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.762396,
      NULL,
      NULL,
      NULL,
      1.813673,
      3,
      NULL,
      1.659451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.368130,
      0.938038,
      0.084504,
      2,
      NULL,
      0.946926,
      1,
      0.444255,
      1,
      0,
      0.873481,
      3.041691,
      0,
      0,
      0.324511,
      0.984945,
      5.766285,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360597,
      NULL,
      NULL,
      NULL,
      1.697688,
      1.256711,
      2.855069,
      0.589897,
      NULL,
      NULL,
      NULL,
      1.319803,
      NULL,
      NULL,
      NULL,
      1.311592,
      NULL,
      NULL,
      3.254063,
      3,
      3,
      2.333677,
      1.305576,
      0.493114,
      NULL,
      NULL,
      1.851682,
      2,
      NULL,
      NULL,
      2.190603,
      11,
      2,
      1,
      5,
      0,
      1.631419,
      1.297686,
      1,
      NULL,
      NULL,
      NULL,
      0.341256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      1.068227,
      1,
      NULL,
      1,
      6.776780,
      4.238239,
      6,
      0.464211,
      1.935160,
      2.034665,
      0.060711,
      NULL,
      NULL,
      3,
      1,
      3,
      3,
      0,
      NULL,
      9.993535,
      4.257798,
      5.549114,
      NULL,
      3.249240,
      1.070576,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3.873276,
      3,
      10,
      4,
      5.802284,
      0.597166,
      4.923279,
      2.408371,
      0,
      NULL,
      7,
      NULL,
      1.966040,
      0.507703,
      0.352430,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.193195,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.001393,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.624259,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.093198,
      0,
      0,
      1,
      NULL,
      1.487647,
      1.701280,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.383066,
      NULL,
      NULL,
      NULL,
      0.830990,
      NULL,
      NULL,
      NULL,
      0.825487,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.600891,
      NULL,
      NULL,
      NULL,
      0.538961,
      NULL,
      NULL,
      3,
      0,
      0,
      1.131840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.781529,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041361,
      16099.439419,
      2.964153,
      0.554192,
      1.237354,
      0,
      1,
      1.621742,
      NULL,
      NULL,
      1,
      NULL,
      1.775977,
      1,
      0,
      NULL,
      1.429932,
      NULL,
      NULL,
      1,
      0.648235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.733996,
      2,
      0.126780,
      NULL,
      2.745529,
      NULL,
      6,
      3,
      3,
      0,
      0,
      0,
      NULL,
      0.042985,
      3.101167,
      NULL,
      0.522096,
      1,
      NULL,
      1.754702,
      NULL,
      NULL,
      NULL,
      1.998843,
      NULL,
      1,
      0.909866,
      NULL,
      0,
      3,
      NULL,
      1.537046,
      3,
      NULL,
      NULL,
      3.356201,
      NULL,
      0,
      3.618139,
      NULL,
      1.079939,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390200,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.744023,
      6.390293,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      30.795341,
      2,
      0.321412,
      0,
      '40101',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.816085,
      '',
      '',
      NULL);
commit;
end;
/


